"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjenrcTs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const javascript_1 = require("../javascript");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
/**
 * A projenrc file written in TypeScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 *
 * Requires that `npx` is available.
 */
class ProjenrcTs extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? ".projenrc.ts";
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        // Create a dedicated tsconfig for projen source files
        this.tsconfig = new javascript_1.TypescriptConfig(project, {
            fileName: options.tsconfigFileName ?? "tsconfig.projen.json",
            compilerOptions: {},
        });
        // Use npx since project's deps manager is not guaranteed to be JS-based
        project.defaultTask?.exec(`npx -y ts-node --project ${this.tsconfig.fileName} ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        this.tsconfig.addInclude(this.filePath);
        this.tsconfig.addInclude(`${this._projenCodeDir}/**/*.ts`);
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.filePath);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        fs_1.writeFileSync(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.ProjenrcTs = ProjenrcTs;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcTs[_a] = { fqn: "projen.typescript.ProjenrcTs", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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