"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses a projenrc.json file, uses it to generate a corresponding
 * projenrc.js file, and then run it to synthesize its contents.
 *
 * Environment variables:
 *
 * - PROJENRC_FILE: (optional) the name of the JSON file to parse from.
 *   Defaults to `.projenrc.json`.
 */
const fs = require("fs");
const option_hints_1 = require("./option-hints");
const projects_1 = require("./projects");
let filename = process.env.PROJENRC_FILE;
if (!filename || filename == "") {
    filename = ".projenrc.json";
}
const { type, ...json } = JSON.parse(fs.readFileSync(filename, "utf8"));
if (!type) {
    throw new Error('projenrc.json requires a "type" field with the fully qualified type name. e.g. projen.web.ReactProject');
}
projects_1.Projects.createProject({
    dir: ".",
    projectFqn: type,
    projectOptions: json,
    optionHints: option_hints_1.InitProjectOptionHints.NONE,
    synth: true,
    post: false,
});
//# sourceMappingURL=data:application/json;base64,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