"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to manage release strategies. This includes release
 * and release artifact automation
 */
class ReleaseTrigger {
    constructor(options = {}) {
        this.isContinuous = options.continuous ?? false;
        this.schedule = options.schedule;
        this.changelogPath = options.changelogPath;
        this.gitPushCommand = options.gitPushCommand;
    }
    /**
     * Creates a manual release trigger.
     *
     * Use this option if you want totally manual releases.
     *
     * This will give you a release task that, in addition to the normal
     * release activities will trigger a `publish:git` task. This task will
     * handle project-level changelog management, release tagging, and pushing
     * these artifacts to origin.
     *
     * The command used for pushing can be customised by specifying
     * `gitPushCommand`. Set to an empty string to disable pushing entirely.
     *
     * Simply run `yarn release` to trigger a manual release.
     *
     * @param options release options
     */
    static manual(options = {}) {
        let changelogPath;
        if (options.changelog ?? true) {
            changelogPath = options.changelogPath ?? "CHANGELOG.md";
        }
        return new ReleaseTrigger({
            changelogPath: changelogPath,
            gitPushCommand: options.gitPushCommand,
        });
    }
    /**
     * Creates a scheduled release trigger.
     *
     * Automated releases will occur based on the provided cron schedule.
     *
     * @param options release options.
     */
    static scheduled(options) {
        return new ReleaseTrigger({
            schedule: options.schedule,
        });
    }
    /**
     * Creates a continuous release trigger.
     *
     * Automated releases will occur on every commit.
     */
    static continuous() {
        return new ReleaseTrigger({
            continuous: true,
        });
    }
    /**
     * Whether or not this is a manual release trigger.
     */
    get isManual() {
        return !(this.isContinuous || this.schedule);
    }
}
exports.ReleaseTrigger = ReleaseTrigger;
_a = JSII_RTTI_SYMBOL_1;
ReleaseTrigger[_a] = { fqn: "projen.release.ReleaseTrigger", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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