"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjenrcFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
/**
 * A component representing the projen runtime configuration
 */
class ProjenrcFile extends component_1.Component {
    /**
     * Returns the `Projenrc` instance associated with a project or `undefined` if
     * there is no Projenrc.
     * @param project The project
     * @returns A Projenrc
     */
    static of(project) {
        const isProjenrc = (o) => o instanceof ProjenrcFile;
        return project.components.find(isProjenrc);
    }
}
exports.ProjenrcFile = ProjenrcFile;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcFile[_a] = { fqn: "projen.ProjenrcFile", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvamVucmMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcHJvamVucmMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBd0M7QUFHeEM7O0dBRUc7QUFDSCxNQUFzQixZQUFhLFNBQVEscUJBQVM7SUFDbEQ7Ozs7O09BS0c7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWdCO1FBQy9CLE1BQU0sVUFBVSxHQUFHLENBQUMsQ0FBWSxFQUFxQixFQUFFLENBQ3JELENBQUMsWUFBWSxZQUFZLENBQUM7UUFDNUIsT0FBTyxPQUFPLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDOztBQVhILG9DQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gXCIuL2NvbXBvbmVudFwiO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gXCIuL3Byb2plY3RcIjtcblxuLyoqXG4gKiBBIGNvbXBvbmVudCByZXByZXNlbnRpbmcgdGhlIHByb2plbiBydW50aW1lIGNvbmZpZ3VyYXRpb25cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFByb2plbnJjRmlsZSBleHRlbmRzIENvbXBvbmVudCB7XG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBgUHJvamVucmNgIGluc3RhbmNlIGFzc29jaWF0ZWQgd2l0aCBhIHByb2plY3Qgb3IgYHVuZGVmaW5lZGAgaWZcbiAgICogdGhlcmUgaXMgbm8gUHJvamVucmMuXG4gICAqIEBwYXJhbSBwcm9qZWN0IFRoZSBwcm9qZWN0XG4gICAqIEByZXR1cm5zIEEgUHJvamVucmNcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YocHJvamVjdDogUHJvamVjdCk6IFByb2plbnJjRmlsZSB8IHVuZGVmaW5lZCB7XG4gICAgY29uc3QgaXNQcm9qZW5yYyA9IChvOiBDb21wb25lbnQpOiBvIGlzIFByb2plbnJjRmlsZSA9PlxuICAgICAgbyBpbnN0YW5jZW9mIFByb2plbnJjRmlsZTtcbiAgICByZXR1cm4gcHJvamVjdC5jb21wb25lbnRzLmZpbmQoaXNQcm9qZW5yYyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIHBhdGggb2YgdGhlIHByb2plbnJjIGZpbGUuXG4gICAqL1xuICBhYnN0cmFjdCByZWFkb25seSBmaWxlUGF0aDogc3RyaW5nO1xufVxuIl19