"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptConfig = exports.TypeScriptJsxMode = exports.TypeScriptImportsNotUsedAsValues = exports.TypeScriptModuleResolution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 */
var TypeScriptModuleResolution;
(function (TypeScriptModuleResolution) {
    /**
     * TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     */
    TypeScriptModuleResolution["CLASSIC"] = "classic";
    /**
     * Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     */
    TypeScriptModuleResolution["NODE"] = "node";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE16"] = "node16";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE_NEXT"] = "nodenext";
})(TypeScriptModuleResolution = exports.TypeScriptModuleResolution || (exports.TypeScriptModuleResolution = {}));
/**
 * This flag controls how `import` works, there are 3 different options.
 *
 * @see https://www.typescriptlang.org/tsconfig#importsNotUsedAsValues
 */
var TypeScriptImportsNotUsedAsValues;
(function (TypeScriptImportsNotUsedAsValues) {
    /**
     * The default behavior of dropping `import` statements which only reference types.
     */
    TypeScriptImportsNotUsedAsValues["REMOVE"] = "remove";
    /**
     * Preserves all `import` statements whose values or types are never used. This can cause imports/side-effects to be preserved.
     */
    TypeScriptImportsNotUsedAsValues["PRESERVE"] = "preserve";
    /**
     * This preserves all imports (the same as the preserve option), but will error when a value import is only used as a type.
     * This might be useful if you want to ensure no values are being accidentally imported, but still make side-effect imports explicit.
     */
    TypeScriptImportsNotUsedAsValues["ERROR"] = "error";
})(TypeScriptImportsNotUsedAsValues = exports.TypeScriptImportsNotUsedAsValues || (exports.TypeScriptImportsNotUsedAsValues = {}));
/**
 * Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 */
var TypeScriptJsxMode;
(function (TypeScriptJsxMode) {
    /**
     * Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     */
    TypeScriptJsxMode["PRESERVE"] = "preserve";
    /**
     * Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     */
    TypeScriptJsxMode["REACT"] = "react";
    /**
     * Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     */
    TypeScriptJsxMode["REACT_NATIVE"] = "react-native";
    /**
     * Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     */
    TypeScriptJsxMode["REACT_JSX"] = "react-jsx";
    /**
     * Same as `REACT_JSX` with additional debug data.
     */
    TypeScriptJsxMode["REACT_JSXDEV"] = "react-jsxdev";
})(TypeScriptJsxMode = exports.TypeScriptJsxMode || (exports.TypeScriptJsxMode = {}));
class TypescriptConfig extends component_1.Component {
    constructor(project, options) {
        super(project);
        const fileName = options.fileName ?? "tsconfig.json";
        this.include = options.include ?? ["**/*.ts"];
        this.exclude = options.exclude ?? ["node_modules"];
        this.fileName = fileName;
        this.compilerOptions = options.compilerOptions;
        this.file = new json_1.JsonFile(project, fileName, {
            allowComments: true,
            obj: {
                compilerOptions: this.compilerOptions,
                include: () => this.include,
                exclude: () => this.exclude,
            },
        });
        if (project instanceof _1.NodeProject) {
            project.npmignore?.exclude(`/${fileName}`);
        }
    }
    addInclude(pattern) {
        this.include.push(pattern);
    }
    addExclude(pattern) {
        this.exclude.push(pattern);
    }
}
exports.TypescriptConfig = TypescriptConfig;
_a = JSII_RTTI_SYMBOL_1;
TypescriptConfig[_a] = { fqn: "projen.javascript.TypescriptConfig", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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