"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prettier = exports.TrailingComma = exports.QuoteProps = exports.ProseWrap = exports.HTMLWhitespaceSensitivity = exports.EndOfLine = exports.EmbeddedLanguageFormatting = exports.ArrowParens = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ignore_file_1 = require("../ignore-file");
const json_1 = require("../json");
const source_code_1 = require("../source-code");
const yaml_1 = require("../yaml");
var ArrowParens;
(function (ArrowParens) {
    /**
     * Always include parens. Example: `(x) => x`
     */
    ArrowParens["ALWAYS"] = "always";
    /**
     * Omit parens when possible. Example: `x => x`
     */
    ArrowParens["AVOID"] = "avoid";
})(ArrowParens = exports.ArrowParens || (exports.ArrowParens = {}));
var EmbeddedLanguageFormatting;
(function (EmbeddedLanguageFormatting) {
    /**
     * Format embedded code if Prettier can automatically identify it.
     */
    EmbeddedLanguageFormatting["AUTO"] = "auto";
    /**
     * Never automatically format embedded code.
     */
    EmbeddedLanguageFormatting["OFF"] = "off";
})(EmbeddedLanguageFormatting = exports.EmbeddedLanguageFormatting || (exports.EmbeddedLanguageFormatting = {}));
var EndOfLine;
(function (EndOfLine) {
    /**
     * Maintain existing (mixed values within one file are normalised by looking
     * at what's used after the first line)
     */
    EndOfLine["AUTO"] = "auto";
    /**
     * Carriage Return character only (\r), used very rarely
     */
    EndOfLine["CR"] = "cr";
    /**
     * Carriage Return + Line Feed characters (\r\n), common on Windows
     */
    EndOfLine["CRLF"] = "crlf";
    /**
     * Line Feed only (\n), common on Linux and macOS as well as inside git repos
     */
    EndOfLine["LF"] = "lf";
})(EndOfLine = exports.EndOfLine || (exports.EndOfLine = {}));
var HTMLWhitespaceSensitivity;
(function (HTMLWhitespaceSensitivity) {
    /**
     * Respect the default value of CSS display property.
     */
    HTMLWhitespaceSensitivity["CSS"] = "css";
    /**
     * Whitespaces are considered insignificant.
     */
    HTMLWhitespaceSensitivity["IGNORE"] = "ignore";
    /**
     * Whitespaces are considered significant.
     */
    HTMLWhitespaceSensitivity["STRICT"] = "strict";
})(HTMLWhitespaceSensitivity = exports.HTMLWhitespaceSensitivity || (exports.HTMLWhitespaceSensitivity = {}));
var ProseWrap;
(function (ProseWrap) {
    /**
     * Wrap prose if it exceeds the print width.
     */
    ProseWrap["ALWAYS"] = "always";
    /**
     * Do not wrap prose.
     */
    ProseWrap["NEVER"] = "never";
    /**
     * Wrap prose as-is.
     */
    ProseWrap["PRESERVE"] = "preserve";
})(ProseWrap = exports.ProseWrap || (exports.ProseWrap = {}));
var QuoteProps;
(function (QuoteProps) {
    /**
     * Only add quotes around object properties where required.
     */
    QuoteProps["ASNEEDED"] = "as-needed";
    /**
     * If at least one property in an object requires quotes, quote all properties.
     */
    QuoteProps["CONSISTENT"] = "consistent";
    /**
     * Respect the input use of quotes in object properties.
     */
    QuoteProps["PRESERVE"] = "preserve";
})(QuoteProps = exports.QuoteProps || (exports.QuoteProps = {}));
var TrailingComma;
(function (TrailingComma) {
    /**
     * Trailing commas wherever possible (including function arguments).
     */
    TrailingComma["ALL"] = "all";
    /**
     * Trailing commas where valid in ES5 (objects, arrays, etc.)
     */
    TrailingComma["ES5"] = "es5";
    /**
     * No trailing commas.
     */
    TrailingComma["NONE"] = "none";
})(TrailingComma = exports.TrailingComma || (exports.TrailingComma = {}));
/**
 * Represents prettier configuration.
 */
class Prettier extends component_1.Component {
    constructor(project, options) {
        super(project);
        this._overrides = options.overrides ?? [];
        if (options.ignoreFile ?? true) {
            this.ignoreFile = new ignore_file_1.IgnoreFile(project, ".prettierignore", options.ignoreFileOptions);
        }
        project.addDevDeps("prettier");
        this.settings = {
            ...options.settings,
        };
        if (options.yaml) {
            new yaml_1.YamlFile(project, ".prettierrc.yml", {
                obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
                marker: true,
            });
        }
        else {
            new json_1.JsonFile(project, ".prettierrc.json", {
                obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
                marker: false,
            });
        }
    }
    static of(project) {
        const isPrettier = (c) => c instanceof Prettier;
        return project.components.find(isPrettier);
    }
    /**
     * Add a prettier override
     * @see https://prettier.io/docs/en/configuration.html#configuration-overrides
     * @param {PrettierOverride} override
     */
    addOverride(override) {
        this._overrides.push(override);
    }
    /**
     * Defines Prettier ignore Patterns
     * these patterns will be added to the file .prettierignore
     *
     * @param pattern filepatterns so exclude from prettier formatting
     */
    addIgnorePattern(pattern) {
        this.ignoreFile?.addPatterns(pattern);
    }
    /**
     *  Returns all Prettier overrides
     */
    get overrides() {
        return [...this._overrides];
    }
    preSynthesize() {
        // Add automatically generated SourceCode files to .prettierignore as they may not be formatted correctly.
        const isSourceCode = (c) => c instanceof source_code_1.SourceCode;
        this.project.components.filter(isSourceCode).forEach((c) => {
            this.addIgnorePattern(c.filePath);
        });
    }
}
exports.Prettier = Prettier;
_a = JSII_RTTI_SYMBOL_1;
Prettier[_a] = { fqn: "projen.javascript.Prettier", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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