"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
const github_1 = require("../github");
const util_1 = require("../util");
/**
 * Java project.
 *
 * @pjid java
 */
class JavaProject extends github_1.GitHubProject {
    constructor(options) {
        super(options);
        this.distdir = options.distdir ?? "dist/java";
        this.pom = new pom_1.Pom(this, options);
        const rcFileTypeOptions = [options.projenrcJava, options.projenrcJson];
        if (util_1.multipleSelected(rcFileTypeOptions)) {
            throw new Error("Only one of projenrcJava and projenrcJson can be selected.");
        }
        // default to projenrc.java if no other projenrc type was elected
        if (!this.parent &&
            (options.projenrcJava ?? !util_1.anySelected(rcFileTypeOptions))) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, options.projenrcJavaOptions);
        }
        const sampleJavaPackage = options.sampleJavaPackage ?? "org.acme";
        if (options.junit ?? true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if (options.sample ?? true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty("project.build.sourceEncoding", "UTF-8");
        this.gitignore.exclude(".classpath");
        this.gitignore.exclude(".project");
        this.gitignore.exclude(".settings");
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin("org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3", {
            executions: [{ id: "enforce-maven", goals: ["enforce"] }],
            configuration: {
                rules: [{ requireMavenVersion: [{ version: "3.6" }] }],
            },
        });
        for (const dep of options.deps ?? []) {
            this.addDependency(dep);
        }
        for (const dep of options.testDeps ?? []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`)
     * @param options plugin options
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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