"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
class IgnoreFile extends file_1.FileBase {
    /**
     *
     * @param project The project to tie this file to.
     * @param filePath - the relative path in the project to put the file
     * @param minify - whether comments/blank lines should be filtered
     */
    constructor(project, filePath, options) {
        super(project, filePath, { editGitignore: filePath !== ".gitignore" });
        this._patterns = new Array();
        this.filterCommentLines = options?.filterCommentLines ?? true;
        this.filterEmptyLines = options?.filterEmptyLines ?? true;
    }
    /**
     * Add ignore patterns. Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) and blank lines ("") are filtered by default
     * but can be included using options specified when instantiating the component.
     *
     * @param patterns Ignore patterns.
     */
    addPatterns(...patterns) {
        for (const pattern of patterns) {
            const isComment = pattern.startsWith("#");
            const isEmptyLine = Boolean(pattern.trim().length === 0);
            if (isComment && this.filterCommentLines) {
                continue;
            }
            if (isEmptyLine && this.filterEmptyLines) {
                continue;
            }
            if (!isComment && !isEmptyLine) {
                this.normalizePatterns(pattern);
            }
            this._patterns.push(pattern);
        }
    }
    normalizePatterns(pattern) {
        const opposite = pattern.startsWith("!") ? pattern.slice(1) : "!" + pattern;
        remove(this._patterns, pattern); // prevent duplicates
        remove(this._patterns, opposite);
        if (pattern.endsWith("/")) {
            const prefix = opposite;
            for (const p of [...this._patterns]) {
                if (p.startsWith(prefix)) {
                    remove(this._patterns, p);
                }
            }
        }
    }
    /**
     * Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     */
    removePatterns(...patterns) {
        for (const p of patterns) {
            remove(this._patterns, p);
        }
    }
    /**
     * Ignore the files that match these patterns.
     * @param patterns The patterns to match.
     */
    exclude(...patterns) {
        return this.addPatterns(...patterns);
    }
    /**
     * Always include the specified file patterns.
     * @param patterns Patterns to include in git commits.
     */
    include(...patterns) {
        for (let pattern of patterns) {
            if (!pattern.startsWith("!")) {
                pattern = "!" + pattern;
            }
            this.addPatterns(pattern);
        }
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            ...this._patterns,
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
}
exports.IgnoreFile = IgnoreFile;
_a = JSII_RTTI_SYMBOL_1;
IgnoreFile[_a] = { fqn: "projen.IgnoreFile", version: "0.69.3" };
// O(n) hooray!
function remove(arr, value) {
    const idx = arr.indexOf(value);
    if (idx >= 0) {
        arr.splice(idx, 1);
    }
}
//# sourceMappingURL=data:application/json;base64,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