"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppPermission = exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission = exports.JobPermission || (exports.JobPermission = {}));
/**
 * The permissions available for an access token for a GitHub App.
 */
var AppPermission;
(function (AppPermission) {
    /** Read-only acccess */
    AppPermission["READ"] = "read";
    /** Read-write access */
    AppPermission["WRITE"] = "write";
    /**
     * Read-write and admin access.
     *
     * Not all permissions support `admin`.
     */
    AppPermission["ADMIN"] = "admin";
})(AppPermission = exports.AppPermission || (exports.AppPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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