"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mergify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
class Mergify extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.rules = new Array();
        this.queues = new Array();
        for (const rule of options.rules ?? []) {
            this.addRule(rule);
        }
        for (const queue of options.queues ?? []) {
            this.addQueue(queue);
        }
    }
    createYamlFile() {
        if (this.yamlFile == null) {
            this.yamlFile = new yaml_1.YamlFile(this.project, ".mergify.yml", {
                obj: {
                    queue_rules: () => this.queues.map((q) => util_1.snakeCaseKeys(q, false)),
                    pull_request_rules: this.rules,
                },
                // Mergify needs to read the file from the repository in order to work.
                committed: true,
            });
        }
    }
    addRule(rule) {
        this.rules.push(rule);
        this.createYamlFile();
    }
    addQueue(queue) {
        this.queues.push(queue);
        this.createYamlFile();
    }
}
exports.Mergify = Mergify;
_a = JSII_RTTI_SYMBOL_1;
Mergify[_a] = { fqn: "projen.github.Mergify", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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