"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const actions_provider_1 = require("./actions-provider");
const dependabot_1 = require("./dependabot");
const github_credentials_1 = require("./github-credentials");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const pull_request_lint_1 = require("./pull-request-lint");
const workflows_1 = require("./workflows");
const component_1 = require("../component");
class GitHub extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.actions = new actions_provider_1.GitHubActionsProvider();
        this.workflowsEnabled = options.workflows ?? true;
        this._downloadLfs = options.downloadLfs;
        if (options.projenCredentials && options.projenTokenSecret) {
            throw new Error("projenTokenSecret is deprecated, please use projenCredentials instead");
        }
        if (options.projenTokenSecret) {
            this.projenCredentials = github_credentials_1.GithubCredentials.fromPersonalAccessToken({
                secret: options.projenTokenSecret,
            });
        }
        else if (options.projenCredentials) {
            this.projenCredentials = options.projenCredentials;
        }
        else {
            this.projenCredentials = github_credentials_1.GithubCredentials.fromPersonalAccessToken({
                secret: "PROJEN_GITHUB_TOKEN",
            });
        }
        if (options.mergify ?? true) {
            this.mergify = new mergify_1.Mergify(this, options.mergifyOptions);
        }
        if (options.pullRequestLint ?? true) {
            new pull_request_lint_1.PullRequestLint(this, options.pullRequestLintOptions);
        }
    }
    /**
     * Returns the `GitHub` component of a project or `undefined` if the project
     * does not have a GitHub component.
     */
    static of(project) {
        const isGitHub = (c) => c instanceof GitHub;
        return project.components.find(isGitHub);
    }
    /**
     * All workflows.
     */
    get workflows() {
        const isWorkflow = (c) => c instanceof workflows_1.GithubWorkflow;
        return this.project.components
            .filter(isWorkflow)
            .sort((w1, w2) => w1.name.localeCompare(w2.name));
    }
    /**
     * Adds a workflow to the project.
     * @param name Name of the workflow
     * @returns a GithubWorkflow instance
     */
    addWorkflow(name) {
        const workflow = new workflows_1.GithubWorkflow(this, name);
        return workflow;
    }
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * Finds a GitHub workflow by name. Returns `undefined` if the workflow cannot be found.
     * @param name The name of the GitHub workflow
     */
    tryFindWorkflow(name) {
        return this.workflows.find((w) => w.name === name);
    }
    /**
     * Whether downloading from LFS is enabled for this GitHub project
     */
    get downloadLfs() {
        return this._downloadLfs ?? this.project.gitattributes.hasLfsPatterns;
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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