"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const auto_approve_1 = require("./auto-approve");
const github_1 = require("./github");
const stale_1 = require("./stale");
const clobber_1 = require("../clobber");
const gitpod_1 = require("../gitpod");
const project_1 = require("../project");
const readme_1 = require("../readme");
const vscode_1 = require("../vscode");
/**
 * GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
class GitHubProject extends project_1.Project {
    constructor(options) {
        super(options);
        this.projectType = options.projectType ?? project_1.ProjectType.UNKNOWN;
        // we only allow these global services to be used in root projects
        const github = options.github ?? (this.parent ? false : true);
        this.github = github
            ? new github_1.GitHub(this, {
                projenTokenSecret: options.projenTokenSecret,
                projenCredentials: options.projenCredentials,
                mergify: options.mergify,
                mergifyOptions: options.mergifyOptions,
                ...options.githubOptions,
            })
            : undefined;
        const vscode = options.vscode ?? (this.parent ? false : true);
        this.vscode = vscode ? new vscode_1.VsCode(this) : undefined;
        this.gitpod = options.gitpod ? new gitpod_1.Gitpod(this) : undefined;
        this.devContainer = options.devContainer
            ? new vscode_1.DevContainer(this)
            : undefined;
        if (options.clobber ?? !this.parent) {
            new clobber_1.Clobber(this);
        }
        new readme_1.SampleReadme(this, options.readme);
        if (options.autoApproveOptions && this.github) {
            this.autoApprove = new auto_approve_1.AutoApprove(this.github, options.autoApproveOptions);
        }
        const stale = options.stale ?? false;
        if (stale && this.github) {
            new stale_1.Stale(this.github, options.staleOptions);
        }
    }
    /**
     * Marks the provided file(s) as being generated. This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     *
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes(glob, "linguist-generated");
    }
}
exports.GitHubProject = GitHubProject;
_a = JSII_RTTI_SYMBOL_1;
GitHubProject[_a] = { fqn: "projen.github.GitHubProject", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLXByb2plY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ2l0aHViL2dpdGh1Yi1wcm9qZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsaURBQWlFO0FBRWpFLHFDQUFpRDtBQUdqRCxtQ0FBOEM7QUFDOUMsd0NBQXFDO0FBQ3JDLHNDQUFtQztBQUNuQyx3Q0FBa0U7QUFDbEUsc0NBQTREO0FBQzVELHNDQUFpRDtBQXVJakQ7Ozs7Ozs7O0dBUUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxpQkFBTztJQXlDeEMsWUFBWSxPQUE2QjtRQUN2QyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsV0FBVyxHQUFHLE9BQU8sQ0FBQyxXQUFXLElBQUkscUJBQVcsQ0FBQyxPQUFPLENBQUM7UUFDOUQsa0VBQWtFO1FBQ2xFLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzlELElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTTtZQUNsQixDQUFDLENBQUMsSUFBSSxlQUFNLENBQUMsSUFBSSxFQUFFO2dCQUNmLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUI7Z0JBQzVDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUI7Z0JBQzVDLE9BQU8sRUFBRSxPQUFPLENBQUMsT0FBTztnQkFDeEIsY0FBYyxFQUFFLE9BQU8sQ0FBQyxjQUFjO2dCQUN0QyxHQUFHLE9BQU8sQ0FBQyxhQUFhO2FBQ3pCLENBQUM7WUFDSixDQUFDLENBQUMsU0FBUyxDQUFDO1FBRWQsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDOUQsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLElBQUksZUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFFcEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLGVBQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO1FBQzVELElBQUksQ0FBQyxZQUFZLEdBQUcsT0FBTyxDQUFDLFlBQVk7WUFDdEMsQ0FBQyxDQUFDLElBQUkscUJBQVksQ0FBQyxJQUFJLENBQUM7WUFDeEIsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUVkLElBQUksT0FBTyxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDbkMsSUFBSSxpQkFBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ25CO1FBRUQsSUFBSSxxQkFBWSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFdkMsSUFBSSxPQUFPLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUM3QyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksMEJBQVcsQ0FDaEMsSUFBSSxDQUFDLE1BQU0sRUFDWCxPQUFPLENBQUMsa0JBQWtCLENBQzNCLENBQUM7U0FDSDtRQUVELE1BQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDO1FBQ3JDLElBQUksS0FBSyxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDeEIsSUFBSSxhQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDOUM7SUFDSCxDQUFDO0lBRUQ7Ozs7Ozs7O09BUUc7SUFDSSxpQkFBaUIsQ0FBQyxJQUFZO1FBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0lBQy9ELENBQUM7O0FBL0ZILHNDQWdHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEF1dG9BcHByb3ZlLCBBdXRvQXBwcm92ZU9wdGlvbnMgfSBmcm9tIFwiLi9hdXRvLWFwcHJvdmVcIjtcbmltcG9ydCB7IEF1dG9NZXJnZU9wdGlvbnMgfSBmcm9tIFwiLi9hdXRvLW1lcmdlXCI7XG5pbXBvcnQgeyBHaXRIdWIsIEdpdEh1Yk9wdGlvbnMgfSBmcm9tIFwiLi9naXRodWJcIjtcbmltcG9ydCB7IEdpdGh1YkNyZWRlbnRpYWxzIH0gZnJvbSBcIi4vZ2l0aHViLWNyZWRlbnRpYWxzXCI7XG5pbXBvcnQgeyBNZXJnaWZ5T3B0aW9ucyB9IGZyb20gXCIuL21lcmdpZnlcIjtcbmltcG9ydCB7IFN0YWxlLCBTdGFsZU9wdGlvbnMgfSBmcm9tIFwiLi9zdGFsZVwiO1xuaW1wb3J0IHsgQ2xvYmJlciB9IGZyb20gXCIuLi9jbG9iYmVyXCI7XG5pbXBvcnQgeyBHaXRwb2QgfSBmcm9tIFwiLi4vZ2l0cG9kXCI7XG5pbXBvcnQgeyBQcm9qZWN0LCBQcm9qZWN0T3B0aW9ucywgUHJvamVjdFR5cGUgfSBmcm9tIFwiLi4vcHJvamVjdFwiO1xuaW1wb3J0IHsgU2FtcGxlUmVhZG1lLCBTYW1wbGVSZWFkbWVQcm9wcyB9IGZyb20gXCIuLi9yZWFkbWVcIjtcbmltcG9ydCB7IERldkNvbnRhaW5lciwgVnNDb2RlIH0gZnJvbSBcIi4uL3ZzY29kZVwiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGBHaXRIdWJQcm9qZWN0YC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHaXRIdWJQcm9qZWN0T3B0aW9ucyBleHRlbmRzIFByb2plY3RPcHRpb25zIHtcbiAgLyoqXG4gICAqIEFkZCBhIEdpdHBvZCBkZXZlbG9wbWVudCBlbnZpcm9ubWVudFxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZ2l0cG9kPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogRW5hYmxlIFZTQ29kZSBpbnRlZ3JhdGlvbi5cbiAgICpcbiAgICogRW5hYmxlZCBieSBkZWZhdWx0IGZvciByb290IHByb2plY3RzLiBEaXNhYmxlZCBmb3Igbm9uLXJvb3QgcHJvamVjdHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHZzY29kZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEVuYWJsZSBHaXRIdWIgaW50ZWdyYXRpb24uXG4gICAqXG4gICAqIEVuYWJsZWQgYnkgZGVmYXVsdCBmb3Igcm9vdCBwcm9qZWN0cy4gRGlzYWJsZWQgZm9yIG5vbi1yb290IHByb2plY3RzLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBnaXRodWI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBPcHRpb25zIGZvciBHaXRIdWIgaW50ZWdyYXRpb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBzZWUgR2l0SHViT3B0aW9uc1xuICAgKi9cbiAgcmVhZG9ubHkgZ2l0aHViT3B0aW9ucz86IEdpdEh1Yk9wdGlvbnM7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgbWVyZ2lmeSBzaG91bGQgYmUgZW5hYmxlZCBvbiB0aGlzIHJlcG9zaXRvcnkgb3Igbm90LlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqIEBkZXByZWNhdGVkIHVzZSBgZ2l0aHViT3B0aW9ucy5tZXJnaWZ5YCBpbnN0ZWFkXG4gICAqL1xuICByZWFkb25seSBtZXJnaWZ5PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogT3B0aW9ucyBmb3IgbWVyZ2lmeVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgb3B0aW9uc1xuICAgKiBAZGVwcmVjYXRlZCB1c2UgYGdpdGh1Yk9wdGlvbnMubWVyZ2lmeU9wdGlvbnNgIGluc3RlYWRcbiAgICovXG4gIHJlYWRvbmx5IG1lcmdpZnlPcHRpb25zPzogTWVyZ2lmeU9wdGlvbnM7XG5cbiAgLyoqXG4gICAqIEFkZCBhIFZTQ29kZSBkZXZlbG9wbWVudCBlbnZpcm9ubWVudCAodXNlZCBmb3IgR2l0SHViIENvZGVzcGFjZXMpXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBkZXZDb250YWluZXI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBZGQgYSBgY2xvYmJlcmAgdGFzayB3aGljaCByZXNldHMgdGhlIHJlcG8gdG8gb3JpZ2luLlxuICAgKiBAZGVmYXVsdCAtIHRydWUsIGJ1dCBmYWxzZSBmb3Igc3VicHJvamVjdHNcbiAgICovXG4gIHJlYWRvbmx5IGNsb2JiZXI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgUkVBRE1FIHNldHVwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHsgZmlsZW5hbWU6ICdSRUFETUUubWQnLCBjb250ZW50czogJyMgcmVwbGFjZSB0aGlzJyB9XG4gICAqIEBleGFtcGxlIFwieyBmaWxlbmFtZTogJ3JlYWRtZS5tZCcsIGNvbnRlbnRzOiAnIyB0aXRsZScgfVwiXG4gICAqL1xuICByZWFkb25seSByZWFkbWU/OiBTYW1wbGVSZWFkbWVQcm9wcztcblxuICAvKipcbiAgICogV2hpY2ggdHlwZSBvZiBwcm9qZWN0IHRoaXMgaXMgKGxpYnJhcnkvYXBwKS5cbiAgICogQGRlZmF1bHQgUHJvamVjdFR5cGUuVU5LTk9XTlxuICAgKiBAZGVwcmVjYXRlZCBubyBsb25nZXIgc3VwcG9ydGVkIGF0IHRoZSBiYXNlIHByb2plY3QgbGV2ZWxcbiAgICovXG4gIHJlYWRvbmx5IHByb2plY3RUeXBlPzogUHJvamVjdFR5cGU7XG5cbiAgLyoqXG4gICAqIEVuYWJsZSBhbmQgY29uZmlndXJlIHRoZSAnYXV0byBhcHByb3ZlJyB3b3JrZmxvdy5cbiAgICogQGRlZmF1bHQgLSBhdXRvIGFwcHJvdmUgaXMgZGlzYWJsZWRcbiAgICovXG4gIHJlYWRvbmx5IGF1dG9BcHByb3ZlT3B0aW9ucz86IEF1dG9BcHByb3ZlT3B0aW9ucztcblxuICAvKipcbiAgICogRW5hYmxlIGF1dG9tYXRpYyBtZXJnaW5nIG9uIEdpdEh1Yi4gSGFzIG5vIGVmZmVjdCBpZiBgZ2l0aHViLm1lcmdpZnlgXG4gICAqIGlzIHNldCB0byBmYWxzZS5cbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b01lcmdlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQ29uZmlndXJlIG9wdGlvbnMgZm9yIGF1dG9tYXRpYyBtZXJnaW5nIG9uIEdpdEh1Yi4gSGFzIG5vIGVmZmVjdCBpZlxuICAgKiBgZ2l0aHViLm1lcmdpZnlgIG9yIGBhdXRvTWVyZ2VgIGlzIHNldCB0byBmYWxzZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBzZWUgZGVmYXVsdHMgaW4gYEF1dG9NZXJnZU9wdGlvbnNgXG4gICAqL1xuICByZWFkb25seSBhdXRvTWVyZ2VPcHRpb25zPzogQXV0b01lcmdlT3B0aW9ucztcblxuICAvKipcbiAgICogQXV0by1jbG9zZSBzdGFsZSBpc3N1ZXMgYW5kIHB1bGwgcmVxdWVzdHMuIFRvIGRpc2FibGUgc2V0IGBzdGFsZWAgdG8gYGZhbHNlYC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBzZWUgZGVmYXVsdHMgaW4gYFN0YWxlT3B0aW9uc2BcbiAgICovXG4gIHJlYWRvbmx5IHN0YWxlT3B0aW9ucz86IFN0YWxlT3B0aW9ucztcblxuICAvKipcbiAgICogQXV0by1jbG9zZSBvZiBzdGFsZSBpc3N1ZXMgYW5kIHB1bGwgcmVxdWVzdC4gU2VlIGBzdGFsZU9wdGlvbnNgIGZvciBvcHRpb25zLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhbGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDaG9vc2UgYSBtZXRob2Qgb2YgcHJvdmlkaW5nIEdpdEh1YiBBUEkgYWNjZXNzIGZvciBwcm9qZW4gd29ya2Zsb3dzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHVzZSBhIHBlcnNvbmFsIGFjY2VzcyB0b2tlbiBuYW1lZCBQUk9KRU5fR0lUSFVCX1RPS0VOXG4gICAqL1xuICByZWFkb25seSBwcm9qZW5DcmVkZW50aWFscz86IEdpdGh1YkNyZWRlbnRpYWxzO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiBhIHNlY3JldCB3aGljaCBpbmNsdWRlcyBhIEdpdEh1YiBQZXJzb25hbCBBY2Nlc3MgVG9rZW4gdG8gYmVcbiAgICogdXNlZCBieSBwcm9qZW4gd29ya2Zsb3dzLiBUaGlzIHRva2VuIG5lZWRzIHRvIGhhdmUgdGhlIGByZXBvYCwgYHdvcmtmbG93c2BcbiAgICogYW5kIGBwYWNrYWdlc2Agc2NvcGUuXG4gICAqXG4gICAqIEBkZWZhdWx0IFwiUFJPSkVOX0dJVEhVQl9UT0tFTlwiXG4gICAqIEBkZXByZWNhdGVkIHVzZSBgcHJvamVuQ3JlZGVudGlhbHNgXG4gICAqL1xuICByZWFkb25seSBwcm9qZW5Ub2tlblNlY3JldD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBHaXRIdWItYmFzZWQgcHJvamVjdC5cbiAqXG4gKiBAZGVwcmVjYXRlZCBUaGlzIGlzIGEgKnRlbXBvcmFyeSogY2xhc3MuIEF0IHRoZSBtb21lbnQsIG91ciBiYXNlIHByb2plY3RcbiAqIHR5cGVzIHN1Y2ggYXMgYE5vZGVQcm9qZWN0YCBhbmQgYEphdmFQcm9qZWN0YCBhcmUgZGVyaXZlZCBmcm9tIHRoaXMsIGJ1dCB3ZVxuICogd2FudCB0byBiZSBhYmxlIHRvIHVzZSB0aGVzZSBwcm9qZWN0IHR5cGVzIG91dHNpZGUgb2YgR2l0SHViIGFzIHdlbGwuIE9uZSBvZlxuICogdGhlIG5leHQgc3RlcHMgdG8gYWRkcmVzcyB0aGlzIGlzIHRvIGFic3RyYWN0IHdvcmtmbG93cyBzbyB0aGF0IGRpZmZlcmVudFxuICogXCJlbmdpbmVzXCIgY2FuIGJlIHVzZWQgdG8gaW1wbGVtZW50IG91ciBDSS9DRCBzb2x1dGlvbnMuXG4gKi9cbmV4cG9ydCBjbGFzcyBHaXRIdWJQcm9qZWN0IGV4dGVuZHMgUHJvamVjdCB7XG4gIC8qKlxuICAgKiBBY2Nlc3MgYWxsIGdpdGh1YiBjb21wb25lbnRzLlxuICAgKlxuICAgKiBUaGlzIHdpbGwgYmUgYHVuZGVmaW5lZGAgZm9yIHN1YnByb2plY3RzLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGdpdGh1YjogR2l0SHViIHwgdW5kZWZpbmVkO1xuXG4gIC8qKlxuICAgKiBBY2Nlc3MgYWxsIFZTQ29kZSBjb21wb25lbnRzLlxuICAgKlxuICAgKiBUaGlzIHdpbGwgYmUgYHVuZGVmaW5lZGAgZm9yIHN1YnByb2plY3RzLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZzY29kZTogVnNDb2RlIHwgdW5kZWZpbmVkO1xuXG4gIC8qKlxuICAgKiBBY2Nlc3MgZm9yIEdpdHBvZFxuICAgKlxuICAgKiBUaGlzIHdpbGwgYmUgYHVuZGVmaW5lZGAgaWYgZ2l0cG9kIGJvb2xlYW4gaXMgZmFsc2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBnaXRwb2Q6IEdpdHBvZCB8IHVuZGVmaW5lZDtcblxuICAvKipcbiAgICogQWNjZXNzIGZvciAuZGV2Y29udGFpbmVyLmpzb24gKHVzZWQgZm9yIEdpdEh1YiBDb2Rlc3BhY2VzKVxuICAgKlxuICAgKiBUaGlzIHdpbGwgYmUgYHVuZGVmaW5lZGAgaWYgZGV2Q29udGFpbmVyIGJvb2xlYW4gaXMgZmFsc2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBkZXZDb250YWluZXI6IERldkNvbnRhaW5lciB8IHVuZGVmaW5lZDtcblxuICAvKlxuICAgKiBXaGljaCBwcm9qZWN0IHR5cGUgdGhpcyBpcy5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwcm9qZWN0VHlwZTogUHJvamVjdFR5cGU7XG5cbiAgLyoqXG4gICAqIEF1dG8gYXBwcm92ZSBzZXQgdXAgZm9yIHRoaXMgcHJvamVjdC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdXRvQXBwcm92ZT86IEF1dG9BcHByb3ZlO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEdpdEh1YlByb2plY3RPcHRpb25zKSB7XG4gICAgc3VwZXIob3B0aW9ucyk7XG5cbiAgICB0aGlzLnByb2plY3RUeXBlID0gb3B0aW9ucy5wcm9qZWN0VHlwZSA/PyBQcm9qZWN0VHlwZS5VTktOT1dOO1xuICAgIC8vIHdlIG9ubHkgYWxsb3cgdGhlc2UgZ2xvYmFsIHNlcnZpY2VzIHRvIGJlIHVzZWQgaW4gcm9vdCBwcm9qZWN0c1xuICAgIGNvbnN0IGdpdGh1YiA9IG9wdGlvbnMuZ2l0aHViID8/ICh0aGlzLnBhcmVudCA/IGZhbHNlIDogdHJ1ZSk7XG4gICAgdGhpcy5naXRodWIgPSBnaXRodWJcbiAgICAgID8gbmV3IEdpdEh1Yih0aGlzLCB7XG4gICAgICAgICAgcHJvamVuVG9rZW5TZWNyZXQ6IG9wdGlvbnMucHJvamVuVG9rZW5TZWNyZXQsXG4gICAgICAgICAgcHJvamVuQ3JlZGVudGlhbHM6IG9wdGlvbnMucHJvamVuQ3JlZGVudGlhbHMsXG4gICAgICAgICAgbWVyZ2lmeTogb3B0aW9ucy5tZXJnaWZ5LFxuICAgICAgICAgIG1lcmdpZnlPcHRpb25zOiBvcHRpb25zLm1lcmdpZnlPcHRpb25zLFxuICAgICAgICAgIC4uLm9wdGlvbnMuZ2l0aHViT3B0aW9ucyxcbiAgICAgICAgfSlcbiAgICAgIDogdW5kZWZpbmVkO1xuXG4gICAgY29uc3QgdnNjb2RlID0gb3B0aW9ucy52c2NvZGUgPz8gKHRoaXMucGFyZW50ID8gZmFsc2UgOiB0cnVlKTtcbiAgICB0aGlzLnZzY29kZSA9IHZzY29kZSA/IG5ldyBWc0NvZGUodGhpcykgOiB1bmRlZmluZWQ7XG5cbiAgICB0aGlzLmdpdHBvZCA9IG9wdGlvbnMuZ2l0cG9kID8gbmV3IEdpdHBvZCh0aGlzKSA6IHVuZGVmaW5lZDtcbiAgICB0aGlzLmRldkNvbnRhaW5lciA9IG9wdGlvbnMuZGV2Q29udGFpbmVyXG4gICAgICA/IG5ldyBEZXZDb250YWluZXIodGhpcylcbiAgICAgIDogdW5kZWZpbmVkO1xuXG4gICAgaWYgKG9wdGlvbnMuY2xvYmJlciA/PyAhdGhpcy5wYXJlbnQpIHtcbiAgICAgIG5ldyBDbG9iYmVyKHRoaXMpO1xuICAgIH1cblxuICAgIG5ldyBTYW1wbGVSZWFkbWUodGhpcywgb3B0aW9ucy5yZWFkbWUpO1xuXG4gICAgaWYgKG9wdGlvbnMuYXV0b0FwcHJvdmVPcHRpb25zICYmIHRoaXMuZ2l0aHViKSB7XG4gICAgICB0aGlzLmF1dG9BcHByb3ZlID0gbmV3IEF1dG9BcHByb3ZlKFxuICAgICAgICB0aGlzLmdpdGh1YixcbiAgICAgICAgb3B0aW9ucy5hdXRvQXBwcm92ZU9wdGlvbnNcbiAgICAgICk7XG4gICAgfVxuXG4gICAgY29uc3Qgc3RhbGUgPSBvcHRpb25zLnN0YWxlID8/IGZhbHNlO1xuICAgIGlmIChzdGFsZSAmJiB0aGlzLmdpdGh1Yikge1xuICAgICAgbmV3IFN0YWxlKHRoaXMuZ2l0aHViLCBvcHRpb25zLnN0YWxlT3B0aW9ucyk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIE1hcmtzIHRoZSBwcm92aWRlZCBmaWxlKHMpIGFzIGJlaW5nIGdlbmVyYXRlZC4gVGhpcyBpcyBhY2hpZXZlZCB1c2luZyB0aGVcbiAgICogZ2l0aHViLWxpbmd1aXN0IGF0dHJpYnV0ZXMuIEdlbmVyYXRlZCBmaWxlcyBkbyBub3QgY291bnQgYWdhaW5zdCB0aGVcbiAgICogcmVwb3NpdG9yeSBzdGF0aXN0aWNzIGFuZCBsYW5ndWFnZSBicmVha2Rvd24uXG4gICAqXG4gICAqIEBwYXJhbSBnbG9iIHRoZSBnbG9iIHBhdHRlcm4gdG8gbWF0Y2ggKGNvdWxkIGJlIGEgZmlsZSBwYXRoKS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vZ2l0aHViL2xpbmd1aXN0L2Jsb2IvbWFzdGVyL2RvY3Mvb3ZlcnJpZGVzLm1kXG4gICAqL1xuICBwdWJsaWMgYW5ub3RhdGVHZW5lcmF0ZWQoZ2xvYjogc3RyaW5nKTogdm9pZCB7XG4gICAgdGhpcy5naXRhdHRyaWJ1dGVzLmFkZEF0dHJpYnV0ZXMoZ2xvYiwgXCJsaW5ndWlzdC1nZW5lcmF0ZWRcIik7XG4gIH1cbn1cbiJdfQ==