"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerComposeService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const docker_compose_1 = require("./docker-compose");
/**
 * A docker-compose service.
 */
class DockerComposeService {
    constructor(serviceName, serviceDescription) {
        if ((!serviceDescription.imageBuild && !serviceDescription.image) ||
            (serviceDescription.imageBuild && serviceDescription.image)) {
            throw new Error(`A service ${serviceName} requires exactly one of a \`imageBuild\` or \`image\` key`);
        }
        this.serviceName = serviceName;
        this.command = serviceDescription.command;
        this.image = serviceDescription.image;
        this.imageBuild = serviceDescription.imageBuild;
        this.dependsOn = serviceDescription.dependsOn ?? [];
        this.volumes = serviceDescription.volumes ?? [];
        this.networks = serviceDescription.networks ?? [];
        this.ports = serviceDescription.ports ?? [];
        this.environment = serviceDescription.environment ?? {};
        this.labels = serviceDescription.labels ?? {};
        this.entrypoint = serviceDescription.entrypoint;
    }
    /**
     * Add a port mapping
     * @param publishedPort Published port number
     * @param targetPort Container's port number
     * @param options Port mapping options
     */
    addPort(publishedPort, targetPort, options) {
        this.ports?.push(docker_compose_1.DockerCompose.portMapping(publishedPort, targetPort, options));
    }
    /**
     * Add an environment variable
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addEnvironment(name, value) {
        this.environment[name] = value;
    }
    /**
     * Make the service depend on another service.
     * @param serviceName
     */
    addDependsOn(serviceName) {
        this.dependsOn.push(serviceName);
    }
    /**
     * Add a volume to the service.
     * @param volume
     */
    addVolume(volume) {
        this.volumes.push(volume);
    }
    /**
     * Add a network to the service.
     * @param network
     */
    addNetwork(network) {
        this.networks.push(network);
    }
    /**
     * Add a label
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addLabel(name, value) {
        this.labels[name] = value;
    }
}
exports.DockerComposeService = DockerComposeService;
_a = JSII_RTTI_SYMBOL_1;
DockerComposeService[_a] = { fqn: "projen.DockerComposeService", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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