"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const internal_1 = require("./internal");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Represents cdk.json file.
 */
class CdkConfig extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.cdkout = options.cdkout ?? "cdk.out";
        this._include = options.watchIncludes ?? [];
        this._exclude = options.watchExcludes ?? [];
        const context = { ...options.context };
        const fflags = options.featureFlags ?? true;
        if (fflags) {
            for (const flag of internal_1.FEATURE_FLAGS) {
                context[flag] = true;
            }
        }
        this.json = new json_1.JsonFile(project, "cdk.json", {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                build: options.buildCommand,
                watch: {
                    include: () => this._include,
                    exclude: () => this._exclude,
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude(".cdk.staging/");
    }
    /**
     * Add includes to `cdk.json`.
     * @param patterns The includes to add.
     */
    addIncludes(...patterns) {
        this._include.push(...patterns);
    }
    /**
     * Add excludes to `cdk.json`.
     * @param patterns The excludes to add.
     */
    addExcludes(...patterns) {
        this._exclude.push(...patterns);
    }
    /**
     * List of glob patterns to be included by CDK.
     */
    get include() {
        return [...this._include];
    }
    /**
     * List of glob patterns to be excluded by CDK.
     */
    get exclude() {
        return [...this._exclude];
    }
}
exports.CdkConfig = CdkConfig;
_a = JSII_RTTI_SYMBOL_1;
CdkConfig[_a] = { fqn: "projen.awscdk.CdkConfig", version: "0.69.3" };
/**
 * Which approval is required when deploying CDK apps.
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    /**
     * Approval is never required
     */
    ApprovalLevel["NEVER"] = "never";
    /**
     * Requires approval on any IAM or security-group-related change
     */
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    /**
     * Requires approval when IAM statements or traffic rules are added; removals don't require approval
     */
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel = exports.ApprovalLevel || (exports.ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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