"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_js_1 = require("./awscdk-deps-js");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * AWS CDK construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    constructor(options) {
        const cdkMajorVersion = semver.parse(options.cdkVersion)?.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1
                ? {
                    pinnedDevDependency: false,
                }
                : undefined,
            workflowNodeVersion: options.minNodeVersion ?? "16.x",
            ...options,
        });
        this.cdkDeps = new awscdk_deps_js_1.AwsCdkDepsJs(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        new auto_discover_1.AutoDiscover(this, {
            srcdir: this.srcdir,
            testdir: this.testdir,
            lambdaOptions: options.lambdaOptions,
            tsconfigPath: this.tsconfigDev.fileName,
            cdkDeps: this.cdkDeps,
            lambdaAutoDiscover: options.lambdaAutoDiscover ?? true,
            edgeLambdaAutoDiscover: options.edgeLambdaAutoDiscover ?? true,
            lambdaExtensionAutoDiscover: options.lambdaExtensionAutoDiscover ?? true,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
    }
    /**
     * The target CDK version for this library.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.69.3" };
/** @deprecated use `AwsCdkConstructLibrary` */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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