"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const awscdk_deps_py_1 = require("./awscdk-deps-py");
const awscdk_pytest_sample_1 = require("./awscdk-pytest-sample");
const __1 = require("..");
const pytest_1 = require("../python/pytest");
const python_project_1 = require("../python/python-project");
/**
 * AWS CDK app in Python
 *
 * @pjid awscdk-app-py
 */
class AwsCdkPythonApp extends python_project_1.PythonProject {
    constructor(options) {
        super({ ...options, pytest: false, sample: false });
        this.cdkDeps = new awscdk_deps_py_1.AwsCdkDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.appEntrypoint = options.appEntrypoint ?? "app.py";
        this.testdir = options.testdir ?? "tests";
        this.cdkTasks = new _1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synthSilent);
        this.cdkConfig = new _1.CdkConfig(this, {
            app: `python ${this.appEntrypoint}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            watchIncludes: ["**"],
            watchExcludes: [
                "README.md",
                "cdk*.json",
                "requirements*.txt",
                "source.bat",
                "**/__init__.py",
                "python/__pycache__",
                "tests",
            ],
            ...options,
        });
        if (options.sample ?? true) {
            new AppCode(this, "app.py", this.cdkDeps.cdkMajorVersion);
            new MyStackCode(this, this.moduleName, this.cdkDeps.cdkMajorVersion);
        }
        if (options.pytest ?? true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
            new awscdk_pytest_sample_1.AwsCdkPytestSample(this, this.pytest.testdir);
        }
    }
    /**
     * The CDK version this app is using.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
}
exports.AwsCdkPythonApp = AwsCdkPythonApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkPythonApp[_a] = { fqn: "projen.awscdk.AwsCdkPythonApp", version: "0.69.3" };
class AppCode extends __1.Component {
    constructor(project, fileName, cdkVersion) {
        super(project);
        let versionImport;
        if (cdkVersion < 2) {
            versionImport = "from aws_cdk.core import App, Environment";
        }
        else {
            versionImport = "from aws_cdk import App, Environment";
        }
        new __1.SampleFile(project, fileName, {
            contents: [
                "import os",
                versionImport,
                `from ${project.moduleName}.main import MyStack`,
                "",
                "# for development, use account/region from cdk cli",
                "dev_env = Environment(",
                "  account=os.getenv('CDK_DEFAULT_ACCOUNT'),",
                "  region=os.getenv('CDK_DEFAULT_REGION')",
                ")",
                "",
                "app = App()",
                `MyStack(app, "${this.project.name}-dev", env=dev_env)`,
                `# MyStack(app, "${this.project.name}-prod", env=prod_env)`,
                "",
                "app.synth()",
            ].join("\n"),
        });
    }
}
class MyStackCode extends __1.Component {
    constructor(project, dir, cdkMajorVersion) {
        super(project);
        let appFile = [];
        appFile.push("import os");
        if (cdkMajorVersion < 2) {
            appFile.push("from aws_cdk.core import Construct, Stack");
        }
        else {
            appFile.push("from aws_cdk import Stack");
            appFile.push("from constructs import Construct");
        }
        appFile.push("");
        appFile.push("");
        appFile.push("class MyStack(Stack):");
        appFile.push("  def __init__(self, scope: Construct, construct_id: str, **kwargs) -> None:");
        appFile.push("    super().__init__(scope, construct_id, **kwargs)");
        appFile.push("");
        appFile.push("    # The code that defines your stack goes here");
        appFile.push("");
        new __1.SampleDir(project, dir, {
            files: {
                "__init__.py": "",
                "main.py": appFile.join("\n"),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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