# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['InstallRelease']

package_data = \
{'': ['*']}

install_requires = \
['python-magic>=0.4.27,<0.5.0', 'requests', 'rich', 'typer>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['install-release = InstallRelease.cli:app']}

setup_kwargs = {
    'name': 'install-release',
    'version': '0.2.5',
    'description': 'A cli tool to install tools based on your device info directly from github releases and keep them updated.',
    'long_description': '# install-release 🚀\n[![Python Version](https://img.shields.io/badge/Python-3.8_to_3.10-xx.svg)](https://shields.io/) [![Downloads](https://static.pepy.tech/personalized-badge/install-release?&units=international_system&left_color=black&right_color=orange&left_text=Downloads)](https://pepy.tech/project/install-release)\n\n`install-release` is a cli tool to install any tool for your device directly from their github releases and keep them updated.\n\nThis can be any tool you want to install, which is pre-compiled for your device and present on github releases.\n\n> Also it\'s mainly for installing tools that are not directly available in the officially by package managers `apt, yum, pacman` etc.\n\n```bash\n# Install install-release\npip install -U install-release\n```\n\n```\n# Example Installation a tool named `gron` directly from its github releases\n\n# install-release get [GITHUB-URL]\n\n❯ install-release get https://github.com/tomnomnom/gron \n```\n\n![demo](.github/images/demo.png)\n\n\nChecking for gron is installed using installed-release:\n\n```\n❯ which gron\n/home/noobi/.release-bin/gron\n\n❯ gron --help\nTransform JSON (from a file, URL, or stdin) into discrete assignments to make it greppable\n... # more\n```\n\n## Prerequisites\n\n- python3.8 or higher\n\n- [libmagic](https://github.com/ahupp/python-magic#installation)\n- Default releases Installation Path is: `~/.release-bin/`,\nThis is the path where installed tools will get stored.\n\n- In order to run installed tools, you need to add the following line your `~/.bashrc` or `~/.zshrc` file:\n\n```bash\nexport PATH=$HOME/.release-bin:$PATH\n```\n\n\n## Install this package\n\n```bash\npip install -U install-release\n```\n\n\n### Example usage `install-release`\n\n\n```\n# Help page\n\n❯ install-release --help\nUsage: install-release [OPTIONS] COMMAND [ARGS]...\n\n  Github Release Installer, based on your system\n\n  Commands:\n    get      | Install github release, cli tool\n    ls       | list all installed release, cli tools\n    rm       | remove any installed release, cli tools\n    upgrade  | Upgrade all installed release, cli tools\n    state    | show currnet stored state\n    config   | Set configs for tool\n    pull     | Install tools from remote state\n    version  | print version of install-release \n```\n\nFor sub command help use: `install-release <sub-command> --help`\n\nExample: `install-release get --help`\n\n\nYou can shorten the command by setting alias to your `.bashrc` or `.zshrc`\n\n```bash\nalias ir="install-release"\n```\nafter this you can you alias directly for easiness\n\nExample: `ir get --help`\n\n#### Install tool from github releases\n\n```bash\n❯ install-release get "https://github.com/ahmetb/kubectx"\n\n📑 Repo     : ahmetb/kubectx\n🌟 Stars    : 13295\n✨ Language : Go\n🔥 Title    : Faster way to switch between clusters and namespaces in kubectl\n\n                              🚀 Install: kubectx                               \n┏━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━━━┓\n┃ Name    ┃ Selected Item                      ┃ Version ┃ Size Mb ┃ Downloads ┃\n┡━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━━━┩\n│ kubectx │ kubectx_v0.9.4_linux_x86_64.tar.gz │ v0.9.4  │ 1.0     │ 43811     │\n└─────────┴────────────────────────────────────┴─────────┴─────────┴───────────┘\nInstall this tool (Y/n): y\n INFO     Downloaded: \'kubectx_v0.9.4_linux_x86_64.tar.gz\' at /tmp/dn_kubectx_ph6i7dmk                                                               utils.py:159\n INFO     install /tmp/dn_kubectx_ph6i7dmk/kubectx /home/noobi/.release-bin/kubectx                                                                  core.py:132\n INFO     Installed: kubectx\n```\n```\n# checking if kubectx is installed\n❯ which kubectx\n/home/noobi/.release-bin/kubectx\n\n❯ kubectx --version\n0.9.4\n```\n\n#### List installed tools\n\n```bash\n❯ install-release ls\n\n                       Installed tools                        \n┏━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓\n┃ Name      ┃ Version ┃ Url                                  ┃\n┡━━━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩\n│ terrascan │ v1.15.2 │ https://github.com/tenable/terrascan │\n│ gron      │ v0.7.1  │ https://github.com/tomnomnom/gron    │\n│ kubectx   │ v0.9.4  │ https://github.com/ahmetb/kubectx    │\n└───────────┴─────────┴──────────────────────────────────────┘    \n```\n\n#### Remove installed release\n\n```bash\n# Remove installed release\n\n❯ install-release rm gron\n    \nINFO     Removed: gron           \n```\n\n#### Update all previously installed tools to the latest version\n\n```bash\n❯ install-release upgrade\n\nFetching: https://github.com/tenable/terrascan#terrascan\nFetching: https://github.com/ahmetb/kubectx#kubectx\n\nFollowing tools will be upgraded:\n\nterrascan\n\nUpgrade these tools, (Y/n): y\n\nUpdating: terrascan, v1.15.0 => v1.15.2\n INFO     Downloaded: \'terrascan_1.15.2_Linux_x86_64.tar.gz\' at /tmp/dn_terrascan_0as71a6v\n INFO     install /tmp/dn_terrascan_0as71a6v/terrascan ~/.release-bin/terrascan\n INFO     Installed: terrascan\n\nProgress... ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00 \n```\n\n#### Config tool installation path\n\n```bash\n❯ install-release config --path ~/.local/bin\n\nINFO   updated path to:  ~/.local/bin\nINFO   Done\n```\n\n#### Config github to token for higher rate limit\n\n\n\n```bash\n❯ install-release config --token [your github token]\n\nINFO: Update token\nINFO: Done.\n```\n',
    'author': 'Rishang',
    'author_email': 'rishangbhavsarcs@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Rishang/install-releases',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
