import type { Context, EventBridgeEvent } from 'aws-lambda';
export declare const handler: (event: EventBridgeEvent<"CodeArtifact Package Version State Change", CodeArtifactDetail>, context: Context) => Promise<import("aws-sdk/lib/request").PromiseResult<import("aws-sdk/clients/sqs").SendMessageResult, import("aws-sdk").AWSError> | undefined>;
/**
 * @see https://docs.aws.amazon.com/codeartifact/latest/ug/service-event-format-example.html
 */
interface CodeArtifactDetail {
    /**
     * The domain that contains the repository that contains the package.
     */
    readonly domainName: string;
    /**
     * The AWS account ID of the owner of the domain.
     */
    readonly domainOwner: string;
    /**
     * The repository that contains the package.
     */
    readonly repositoryName: string;
    /**
     * The format of the package that triggered the event.
     */
    readonly packageFormat: string;
    /**
     * The namespace of the package that triggered the event.
     */
    readonly packageNamespace?: string;
    /**
     * The name of the package that triggered the event.
     */
    readonly packageName: string;
    /**
     * The version of the package that triggered the event.
     */
    readonly packageVersion: string;
    /**
     * The state of the package version when the event was triggered.
     */
    readonly packageVersionState: 'Unfinished' | 'Published' | 'Unlisted' | 'Archived' | 'Disposed';
    /**
     * A value that uniquely identifies the state of the assets and metadata of the package version when the event was
     * triggered. If the package version is modified (for example, by adding another JAR file to a Maven package), the
     * packageVersionRevision changes.
     */
    readonly packageVersionRevision: string;
    readonly changes: {
        /**
         * The number of assets added to a package that triggered an event. Examples of an asset are a Maven JAR file or a
         * Python wheel.
         */
        readonly assetsAdded: number;
        /**
         * The number of assets removed from a package that triggered an event.
         */
        readonly assetsRemoved: number;
        /**
         * The number of assets modified in the package that triggered the event.
         */
        readonly metadataUpdated: boolean;
        /**
         * A boolean value that is set to true if the event includes modified package-level metadata. For example, an event
         * might modify a Maven pom.xml file.
         */
        readonly assetsUpdated: number;
        /**
         * A boolean value that is set to true if the event's packageVersionStatus is modified(for example, if
         * packageVersionStatus changes from Unfinished to Published).
         */
        readonly statusChanged: boolean;
    };
    /**
     * Describes the high-level type of the package version change.
     */
    readonly operationType: 'Created' | 'Updated' | 'Deleted';
    /**
     * An integer that specifies an event number for a package. Each event on a package increments the sequenceNumber so
     * events can be arranged sequentially. An event can increment the sequenceNumber by any integer number.
     */
    readonly sequenceNumber: number;
    /**
     * An ID used to differentiate duplicate EventBridge events. In rare cases, EventBridge might trigger the same rule
     * more than once for a single event or scheduled time. Or, it might invoke the same target more than once for a given
     * triggered rule.
     */
    readonly eventDeduplicationId: string;
}
export {};
