import type { Got } from 'got/dist/source/types';
export declare enum NpmDownloadsPeriod {
    /**
     * Gets downloads for the last available day. In practice, this will usually
     * be "yesterday" (in GMT) but if stats for that day have not yet landed, it
     * will be the day before.
     */
    LAST_DAY = "last-day",
    /**
     * Gets downloads for the last 7 available days.
     */
    LAST_WEEK = "last-week",
    /**
     * Gets downloads for the last 30 available days.
     */
    LAST_MONTH = "last-month"
}
export interface NpmDownloadsEntry {
    readonly downloads: number;
    readonly start: string;
    readonly end: string;
    readonly package: string;
}
export declare type NpmDownloadsOutput = Map<string, NpmDownloadsEntry>;
export interface NpmDownloadsOptions {
    /**
     * The period to query for package download counts.
     * @default NpmDownloadsPeriod.LAST_WEEK
     */
    readonly period?: NpmDownloadsPeriod;
    /**
     * Throw an error when any package's download metrics are not available.
     * @default true
     */
    readonly throwErrors?: boolean;
}
export declare class NpmDownloadsClient {
    static readonly NPM_DOWNLOADS_API_URL = "https://api.npmjs.org/downloads/point";
    static readonly MAX_PACKAGES_PER_QUERY = 128;
    private readonly got;
    constructor(gotService: Got);
    private getDownloadsRaw;
    /**
     * Retrieves the number of downloads each package has on npm in the latest period.
     * Output is not guaranteed to be returned in a specific order.
     * If throwErrors option is specified, an error is thrown when a package's
     * download count is unavailable - otherwise, it's just omitted from
     * the output.
     */
    getDownloads(packages: string[], options?: NpmDownloadsOptions): Promise<NpmDownloadsOutput>;
    private isScopedPackage;
}
