# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['cloud_radar', 'cloud_radar.cf', 'cloud_radar.cf.e2e', 'cloud_radar.cf.unit']

package_data = \
{'': ['*']}

install_requires = \
['cfn-flip>=1.2.3,<2.0.0', 'taskcat>=0.9.20,<0.10.0']

setup_kwargs = {
    'name': 'cloud-radar',
    'version': '0.6.3',
    'description': 'Run functional tests on cloudformation stacks.',
    'long_description': '<!-- PROJECT SHIELDS -->\n<!--\n*** I\'m using markdown "reference style" links for readability.\n*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).\n*** See the bottom of this document for the declaration of the reference variables\n*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.\n*** https://www.markdownguide.org/basic-syntax/#reference-style-links\n-->\n[![Python][python-shield]][pypi-url]\n[![Latest][version-shield]][pypi-url]\n[![Tests][test-shield]][test-url]\n[![Coverage][codecov-shield]][codecov-url]\n[![License][license-shield]][license-url]\n<!-- [![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url] -->\n\n<!-- PROJECT LOGO -->\n<br />\n<p align="center">\n  <!-- <a href="https://github.com/DontShaveTheYak/cloud-radar">\n    <img src="images/logo.png" alt="Logo" width="80" height="80">\n  </a> -->\n\n  <h3 align="center">Cloud-Radar</h3>\n\n  <p align="center">\n    Write unit and functional tests for AWS Cloudformation.\n    <!-- <br />\n    <a href="https://github.com/DontShaveTheYak/cloud-radar"><strong>Explore the docs »</strong></a>\n    <br /> -->\n    <br />\n    <!-- <a href="https://github.com/DontShaveTheYak/cloud-radar">View Demo</a>\n    · -->\n    <a href="https://github.com/DontShaveTheYak/cloud-radar/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/DontShaveTheYak/cloud-radar/issues">Request Feature</a>\n    ·\n    <a href="https://la-tech.co/post/hypermodern-cloudformation/getting-started/">Guide</a>\n  </p>\n</p>\n\n\n\n<!-- TABLE OF CONTENTS -->\n<details open="open">\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgements">Acknowledgements</a></li>\n  </ol>\n</details>\n\n## About The Project\n\n<!-- [![Product Name Screen Shot][product-screenshot]](https://example.com) -->\n\nCloud-Radar is a python module that allows testing of Cloudformation Templates/Stacks using Python.\n\n### Unit Testing\n\nYou can now unit test the logic contained inside your Cloudformation template. Cloud-Radar takes your template, the desired region and some parameters. We render the template into its final state and pass it back to you.\n\nYou can Test:\n* That Conditionals in your template evaluate to the correct value.\n* Conditional resources were created or not.\n* That resources have the correct properties.\n* That resources are named as expected because of `!Sub`.\n\nYou can test all this locally without worrying about AWS Credentials.\n\n### Functional Testing\n\nThis project is a wrapper around Taskcat. Taskcat is a great tool for ensuring your Cloudformation Template can be deployed in multiple AWS Regions. Cloud-Radar enhances Taskcat by making it easier to write more complete functional tests.\n\nHere\'s How:\n* You can interact with the deployed resources directly with tools you already know like boto3.\n* You can control the lifecycle of the stack. This allows testing if resources were retained after the stacks were deleted.\n* You can run tests without hardcoding them in a taskcat config file.\n\nThis project is new and it\'s possible not all features or functionality of Taskcat/Cloudformation are supported (see [Roadmap](#roadmap)). If you find something missing or have a use case that isn\'t covered then please let me know =)\n\n### Built With\n\n* [Taskcat](https://github.com/aws-quickstart/taskcat)\n* [cfn_tools from cfn-flip](https://github.com/awslabs/aws-cfn-template-flip)\n\n## Getting Started\n\nCloud-Radar is available as an easy to install pip package.\n\n### Prerequisites\n\nCloud-Radar requires python >= 3.8\n\n### Installation\n\n1. Install with pip.\n   ```sh\n   pip install cloud-radar\n   ```\n\n## Usage\n<details>\n<summary>Unit Testing <span style=\'font-size: .67em\'>(Click to expand)</span></summary>\n\nUsing Cloud-Radar starts by importing it into your test file or framework. We will use this [Template](./tests/templates/log_bucket/log_bucket.yaml) as an example.\n\n```python\nfrom pathlib import Path\nfrom cloud_radar.cf.unit import Template\n\ntemplate_path = Path("tests/templates/log_bucket/log_bucket.yaml")\n\n# template_path can be a str or a Path object\ntemplate = Template.from_yaml(template_path.resolve())\n\nparams = {"BucketPrefix": "testing", "KeepBucket": "TRUE"}\n\n# parameters and region are optional arguments.\nresult = template.render(params, region="us-west-2")\n\nassert "LogsBucket" not in result["Resources"]\n\nbucket = result["Resources"]["RetainLogsBucket"]\n\nassert "DeletionPolicy" in bucket\n\nassert bucket["DeletionPolicy"] == "Retain"\n\nbucket_name = bucket["Properties"]["BucketName"]\n\nassert "us-west-2" in bucket_name\n```\n\nThe AWS pseudo variables are all class attributes and can be modified before rendering a template.\n```python\n# The value of \'AWS::AccountId\' in !Sub "My AccountId is ${AWS::AccountId}" can be changed:\nTemplate.AccountId = \'8675309\'\n```\n_Note: Region should only be changed to change the default value. To change the region during testing pass the desired region to render(region=\'us-west-2\')_\n\nThe default values for psedo variables:\n\n| Name             | Default Value   |\n| ---------------- | --------------- |\n| AccountId        | "555555555555"  |\n| NotificationARNs | []              |\n| **NoValue**      | ""              |\n| **Partition**    | "aws"           |\n| Region           | "us-east-1"     |\n| **StackId**      | ""              |\n| **StackName**    | ""              |\n| **URLSuffix**    | "amazonaws.com" |\n_Note: Bold variables are not fully impletmented yet see the [Roadmap](#roadmap)_\n\nA real unit testing example using Pytest can be seen [here](./tests/test_cf/test_examples/test_unit.py)\n\n</details>\n\n<details>\n<summary>Functional Testing <span style=\'font-size: .67em\'>(Click to expand)</span></summary>\nUsing Cloud-Radar starts by importing it into your test file or framework.\n\n```python\nfrom pathlib import Path\n\nfrom cloud_radar.cf.e2e import Stack\n\n# Stack is a context manager that makes sure your stacks are deleted after testing.\ntemplate_path = Path("tests/templates/log_bucket/log_bucket.yaml")\nparams = {"BucketPrefix": "testing", "KeepBucket": "False"}\nregions = [\'us-west-2\']\n\n# template_path can be a string or a Path object.\n# params can be optional if all your template params have default values\n# regions can be optional, default region is \'us-east-1\'\nwith Stack(template_path, params, regions) as stacks:\n    # Stacks will be created and returned as a list in the stacks variable.\n\n    for stack in stacks:\n        # stack will be an instance of Taskcat\'s Stack class.\n        # It has all the expected properties like parameters, outputs and resources\n\n        print(f"Testing {stack.name}")\n\n        bucket_name = ""\n\n        for output in stack.outputs:\n\n            if output.key == "LogsBucketName":\n                bucket_name = output.value\n                break\n\n        assert "logs" in bucket_name\n\n        assert stack.region.name in bucket_name\n\n        print(f"Created bucket: {bucket_name}")\n\n# Once the test is over then all resources will be deleted from your AWS account.\n```\n\nYou can use taskcat [tokens](https://aws.amazon.com/blogs/infrastructure-and-automation/a-deep-dive-into-testing-with-taskcat/) in your parameter values.\n\n```python\nparameters = {\n  "BucketPrefix": "taskcat-$[taskcat_random-string]",\n  "KeepBucket": "FALSE",\n}\n```\n\nYou can skip the context manager. Here is an example for `unittest`\n\n```python\nimport unittest\n\nfrom cloud-radar.cf.e2e import Stack\n\nclass TestLogBucket(unittest.TestCase):\n    @classmethod\n    def setUpClass(cls):\n        template_path = Path("tests/templates/log_bucket/log_bucket.yaml")\n        cls.test = Stack(template_path)\n        cls.test.create()\n\n    @classmethod\n    def tearDownClass(cls):\n        cls.test.delete()\n\n    def test_bucket(self):\n        stacks = self.__class__.test.stacks\n\n        for stack in stacks:\n            # Test\n```\n\nAll the properties and methods of a [stack instance](https://github.com/aws-quickstart/taskcat/blob/main/taskcat/_cfn/stack.py#L188).\n\nA real functional testing example using Pytest can be seen [here](./tests/test_cf/test_examples/test_functional.py)\n\n</details>\n\n## Roadmap\n\n### Project\n- Python 3.7 support\n- Add Logging\n- Add Logo\n- Make it easier to interact with stack resources.\n  * Getting a resource for testing should be as easy as `stack.Resources(\'MyResource)` or `template.Resources(\'MyResource\')`\n- Easier to pick regions for testing\n\n### Unit\n- Add full functionality to pseudo variables.\n  * Variables like `Partition`, `URLSuffix` should change if the region changes.\n  * Variables like `StackName` and `StackId` should have a better default than ""\n- Handle References to resources that shouldn\'t exist.\n  * It\'s currently possible that a `!Ref` to a Resource stays in the final template even if that resource is later removed because of a conditional.\n- Handle function order\n  * Some functions are only allowed in [certain parts](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html) of the template.\n\n### Functional\n- Add the ability to update a stack instance to Taskcat.\n\nSee the [open issues](https://github.com/DontShaveTheYak/cloud-radar/issues) for a list of proposed features (and known issues).\n\n## Contributing\n\nContributions are what make the open-source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nThis project uses poetry to manage dependencies and pre-commit to run formatting, linting and tests. You will need to have both installed to your system as well as python 3.9.\n\n1. Fork the Project\n2. Setup environment (`poetry install`)\n3. Setup commit hooks (`pre-commit install`)\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\n## License\n\nDistributed under the Apache-2.0 License. See [LICENSE.txt](./LICENSE.txt) for more information.\n\n## Contact\n\nLevi - [@shady_cuz](https://twitter.com/shady_cuz)\n\n<!-- ACKNOWLEDGEMENTS -->\n## Acknowledgements\n* [Taskcat](https://aws-quickstart.github.io/taskcat/)\n* [Hypermodern Python](https://cjolowicz.github.io/posts/hypermodern-python-01-setup/)\n* [Best-README-Template](https://github.com/othneildrew/Best-README-Template)\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[python-shield]: https://img.shields.io/pypi/pyversions/cloud-radar?style=for-the-badge\n[version-shield]: https://img.shields.io/pypi/v/cloud-radar?label=latest&style=for-the-badge\n[pypi-url]: https://pypi.org/project/cloud-radar/\n[test-shield]: https://img.shields.io/github/workflow/status/DontShaveTheYak/cloud-radar/Tests?label=Tests&style=for-the-badge\n[test-url]: https://github.com/DontShaveTheYak/cloud-radar/actions?query=workflow%3ATests+branch%3Amaster\n[codecov-shield]: https://img.shields.io/codecov/c/gh/DontShaveTheYak/cloud-radar?color=green&style=for-the-badge&token=NE5C92139X\n[codecov-url]: https://codecov.io/gh/DontShaveTheYak/cloud-radar\n[contributors-shield]: https://img.shields.io/github/contributors/DontShaveTheYak/cloud-radar.svg?style=for-the-badge\n[contributors-url]: https://github.com/DontShaveTheYak/cloud-radar/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/DontShaveTheYak/cloud-radar.svg?style=for-the-badge\n[forks-url]: https://github.com/DontShaveTheYak/cloud-radar/network/members\n[stars-shield]: https://img.shields.io/github/stars/DontShaveTheYak/cloud-radar.svg?style=for-the-badge\n[stars-url]: https://github.com/DontShaveTheYak/cloud-radar/stargazers\n[issues-shield]: https://img.shields.io/github/issues/DontShaveTheYak/cloud-radar.svg?style=for-the-badge\n[issues-url]: https://github.com/DontShaveTheYak/cloud-radar/issues\n[license-shield]: https://img.shields.io/github/license/DontShaveTheYak/cloud-radar.svg?style=for-the-badge\n[license-url]: https://github.com/DontShaveTheYak/cloud-radar/blob/master/LICENSE.txt\n[product-screenshot]: images/screenshot.png\n',
    'author': 'Levi Blaney',
    'author_email': 'shadycuz@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/DontShaveTheYak/cloud-radar',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
