from typing import Dict, List

from cloudrail.knowledge.context.azure.azure_environment_context import AzureEnvironmentContext
from cloudrail.knowledge.context.azure.resources.databases.azure_mssql_server_security_alert_policy import AzureMsSqlServerSecurityAlertPolicyState
from cloudrail.knowledge.rules.azure.azure_base_rule import AzureBaseRule
from cloudrail.knowledge.rules.base_rule import Issue
from cloudrail.knowledge.rules.rule_parameters.base_paramerter import ParameterType


class SqlServerIncludeVulnerabilityAssessmentWithEmailRule(AzureBaseRule):

    def get_id(self) -> str:
        return 'non_car_sql_servers_vulnerability_assessment_email_scan_reports'

    def execute(self, env_context: AzureEnvironmentContext, parameters: Dict[ParameterType, any]) -> List[Issue]:
        issues: List[Issue] = []
        for sql_server in env_context.sql_servers:
            if sql_server.security_alert_policy_list and any(policy.vulnerability_assessment for policy in sql_server.security_alert_policy_list
                                                             if policy.state == AzureMsSqlServerSecurityAlertPolicyState.ENABLED):
                if vulnerability_assessment := next((policy.vulnerability_assessment for policy in sql_server.security_alert_policy_list
                                                     if not policy.vulnerability_assessment.recurring_scans_settings
                                                     or not policy.vulnerability_assessment.recurring_scans_settings.emails), None):
                    issues.append(
                    Issue(
                        f'The {sql_server.get_type()} `{sql_server.get_friendly_name()}` does '
                        f'not have email recipients for vulnerability assessment scans reports',
                        sql_server,
                        vulnerability_assessment))
        return issues

    def should_run_rule(self, environment_context: AzureEnvironmentContext) -> bool:
        return bool(environment_context.sql_servers)
