from cloudrail.knowledge.context.azure.resources.constants.azure_resource_type import AzureResourceType
from cloudrail.knowledge.context.azure.resources.databases.azure_mssql_server_vulnerability_assessment import AzureMsSqlServerVulnerabilityAssessment, \
    AzureMsSqlServerVulnerabilityAssessmentRecurringScans
from cloudrail.knowledge.context.azure.resources_builders.terraform.azure_terraform_builder import AzureTerraformBuilder


class SqlServerVulnerabilityAssessmentBuilder(AzureTerraformBuilder):

    def do_build(self, attributes: dict) -> AzureMsSqlServerVulnerabilityAssessment:
        ## Recurring Scans
        recurring_scans_settings = None
        if recurring_scans_data := self._get_known_value(attributes, 'recurring_scans'):
            recurring_scans_settings = AzureMsSqlServerVulnerabilityAssessmentRecurringScans(enabled=self._get_known_value(recurring_scans_data[0], 'enabled', False),
                                                                                             email_subscription_admins=self._get_known_value(recurring_scans_data[0],
                                                                                                                                             'email_subscription_admins',
                                                                                                                                             False),
                                                                                             emails=self._get_known_value(recurring_scans_data[0], 'emails'))
        return AzureMsSqlServerVulnerabilityAssessment(server_security_alert_policy_id=attributes['server_security_alert_policy_id'],
                                                       storage_container_path=attributes['storage_container_path'],
                                                       storage_account_access_key=self._get_known_value(attributes, 'storage_account_access_key'),
                                                       storage_container_sas_key=self._get_known_value(attributes, 'storage_container_sas_key'),
                                                       recurring_scans_settings=recurring_scans_settings)

    def get_service_name(self) -> AzureResourceType:
        return AzureResourceType.AZURERM_MSSQL_SERVER_VULNERABILITY_ASSESSMENT
