from cloudrail.knowledge.context.azure.resources.databases.azure_mssql_server_vulnerability_assessment import AzureMsSqlServerVulnerabilityAssessment, \
    AzureMsSqlServerVulnerabilityAssessmentRecurringScans
from cloudrail.knowledge.context.azure.resources_builders.scanner.base_azure_scanner_builder import BaseAzureScannerBuilder

class SqlServerVulnerabilityAssessmentBuilder(BaseAzureScannerBuilder):

    def get_file_name(self) -> str:
        return 'sql-servers-vulnerability-assessments.json'

    def do_build(self, attributes: dict) -> AzureMsSqlServerVulnerabilityAssessment:
        properties= attributes['properties']
        ## Recurring Scans
        recurring_scans_settings = None
        if recurring_scans_data := properties.get('recurringScans'):
            recurring_scans_settings = AzureMsSqlServerVulnerabilityAssessmentRecurringScans(enabled=recurring_scans_data['isEnabled'],
                                                                                             email_subscription_admins=recurring_scans_data['emailSubscriptionAdmins'],
                                                                                             emails=recurring_scans_data.get('emails'))
        server_security_alert_policy_id = ''.join((attributes['id'].split('vulnerabilityAssessments')[0], 'securityAlertPolicies/Default'))
        return AzureMsSqlServerVulnerabilityAssessment(server_security_alert_policy_id=server_security_alert_policy_id,
                                                       storage_container_path=properties.get('storageContainerPath'),
                                                       storage_account_access_key=properties.get('storageAccountAccessKey'),
                                                       storage_container_sas_key=properties.get('storageContainerSasKey'),
                                                       recurring_scans_settings=recurring_scans_settings)
