# `csle-cli`

The command-line-interface (CLI) tool for CSLE.

[![PyPI version](https://badge.fury.io/py/csle-agents.svg)](https://badge.fury.io/py/csle-cli)
![PyPI - Downloads](https://img.shields.io/pypi/dm/csle-cli)

## Quickstart

To see the available commands, run:

```bash
csle --help
```

Examples:

- Initialize management accounts

```bash
csle init
```

- List available containers, emulations, images, and networks:

```bash
csle ls --all
```

- List containers only

```bash
csle ls containers --all
```

- List running containers only

```bash
csle ls containers
```

- List emulations

```bash
csle ls emulations --all
```

- List running emulations only

```bash
csle ls emulations
```

- Inspect a specific emulation/container/image/network

```bash
csle ls <name>
```

- Start/Stop/Clean a specific emulation/container

```bash
csle start | stop | clean <name>
```

- Open a shell in a given container

```bash
csle shell <container-name>
```

- Remove a container, image, network, emulation, or all

```bash
csle rm <container-name> | <network-name> | <image-name> | <emulation-name> all
```

- Install emulations, simulations, the metastore, or Docker images

```bash
csle install emulations | simulations | derived_images | base_images | <emulation_name> | <simulation_name> | <derived_image_name> | <base_image_name> | metastore | all
```

- Uninstall emulations, simulations, the metastore, or Docker images

```bash
csle uninstall emulations | simulations | derived_images | base_images | <emulation_name> | <simulation_name> | <derived_image_name> | <base_image_name> | metastore | all
```

- Start trainnig job with a given id

```bash
csle trainingjob <id>
```

- Start system identification job with a given id

```bash
csle systemidentificationjob <id>
```

- Start data collection job with a given id

```bash
csle datacollectionjob <id>
```

- Start the REST API

```bash
csle start flask
```

- Start grafana

```bash
csle start | stop grafana
```

- Start prometheus

```bash
csle start | stop prometheus
```

- Start cadvisor

```bash
csle start | stop cadvisor
```

- Start node-exporter

```bash
csle start | stop nodeexporter
```

## Available Commands

| command                   | description                                                                                                                                                                                          | argument 1                                                                                                                                                                                          | argument 2                                                                   | argument 3 | argument 4    | argument 5 | argument 6 | flags                                                                                                                                                                                                                                                                                                                                                                                 | 
|:--------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-----------------------------------------------------------------------------|:-----------|:--------------|:-----------|:-----------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `attacker`                | Opens an attacker shell in the given emulation execution                                                                                                                                             | `emulation_name`                                                                                                                                                                                    | `execution_id`                                                               |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `clean`                   | Removes a container, a network, an image, all networks, all images, all containers, all traces, or all statistics                                                                                    | `all`,`containers`,`emulations`,`emulation_traces`,`simulation_traces`,`emulation_statistics`,`emulation_executions`,`name`                                                                         | `execution_id`                                                               |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `em`                      | Extracts status information of a given emulation                                                                                                                                                     | `emulation_name`                                                                                                                                                                                    |                                                                              |            |               |            |            | `--host` (check status of host managers), `--stats` (check status of Docker stats manager), `--kafka` (check status of kafka), `--snortids` (check status of the Snort IDS), `--clients` (check status of client population) `--executions` (check status of executions)                                                                                                              |
| `init`                    | Initializes CSLE and sets up management accounts                                                                                                                                                     |                                                                                                                                                                                                     |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `install`                 | Installs emulations and simulations in the metastore and creates Docker images                                                                                                                       | `emulations`, `simulations`, `emulation_name`, `simulation_name`, `derived_images`, `base_images`, `metastore`, `all`                                                                               |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `ls`                      | Lists the set of containers, networks, images, or emulations, or all                                                                                                                                 | `containers`, `networks`, `images`, `emulations`, `all`, `environments`, `prometheus`, `node_exporter`, `cadvisor`, `statsmanager`, `managementsystem`, `simulations`, `emulation_executions`       |                                                                              |            |               |            |            | `--all` (list extended information), `--running` (list running entities only (default)), `--stopped` (list stopped entities only)                                                                                                                                                                                                                                                     |
| `rm`                      | Removes a container, a network, an image, all networks, all images, or all containers                                                                                                                | `network_name`, `container_name`, `image_name`, `networks`, `images`, `containers`                                                                                                                  |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                         |
| `shell`                   | Command for opening a shell inside a running container                                                                                                                                               | `container_name`                                                                                                                                                                                    |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |    
| `start`                   | Starts an entity, e.g. a container or the management system                                                                                                                                          | `prometheus`, `node_exporter`, `grafana`, `cadvisor`, `flask`, `nginx`, `docker`, `postgresql`, `container_name`, `emulation_name`, `all`, `statsmanager`, `training_job`, `system_id_job`, `image` | `container_name` (if the first argument corresponds to a container image),   |            |               |            |            | `--id` (execution id), `--no_clients` (skip starting client population), `--no_traffic` (skip starting traffic generators), `--no_network` (skip creating virtual networks) `--ip` (to start a service on a specific node)                                                                                                                                                            |  
| `start_traffic`           | Starts the traffic and client population on a given emulation                                                                                                                                        | `emulation_name`                                                                                                                                                                                    | `execution_id`                                                               |            |               |            |            | `--mu` (the mu paramter for the service time of the client arrivals), `--lamb` (the lambda parameter of the client arrival process), `--t` (time-step length to measure the arrival process), `--nc` (number of commands per client), `--tsf` (the time scaling factor for non-stationary Poisson processes),`--psf` (the period scaling factor for non-stationary Poisson processes) |
| `statsmanager`            | Starts the statsmanager locally                                                                                                                                                                      | `port`                                                                                                                                                                                              | `log_dir`                                                                    | `log_file` | `max_workers` |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `stop`                    | Stops an entity, e.g. an emulation execution or a container                                                                                                                                          | `emulation_name`, `prometheus`, `node_exporter`, `cadvisor`, `grafana`, `flask`, `nginx`, `docker`, `postgresql`, `container_name`, `statsmanager`, `emulation_executions`, `all`                   | `execution_id`                                                               |            |               |            |            | `--ip` (to stop a service on a specific node)                                                                                                                                                                                                                                                                                                                                         |
| `stop_traffic`            | Stops the traffic and client population on a given emulation                                                                                                                                         | `emulation_name`                                                                                                                                                                                    | `execution_id`                                                               |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `systemidentificationjob` | Starts a systemidentification job with the given id                                                                                                                                                  | `job_id`                                                                                                                                                                                            |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `trainingjob`             | Starts a training job with the given id                                                                                                                                                              | `job_id`                                                                                                                                                                                            |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `datacollectionjob`       | Starts a data collection job with the given id                                                                                                                                                       | `job_id`                                                                                                                                                                                            |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |
| `uninstall`               | Uninstall emulations and simulations from the metastore and removes Docker images                                                                                                                    | `emulations`, `simulations`, `emulation_name`, `simulation_name`, `derived_images`, `base_images`, `metastore`, `all`                                                                               |                                                                              |            |               |            |            |                                                                                                                                                                                                                                                                                                                                                                                       |

## Requirements

- Python 3.8+
- `click>=8.0.0`
- `csle-common`
- `csle-cluster`
- `csle-collector`
- `csle-attacker`
- `csle-defender`
- `csle-system-identification`
- `gym-csle-stopping-game`
- `csle-agents`

## Development Requirements

- Python 3.8+
- `flake8` (for linting)
- `tox` (for automated testing)
- `pytest` (for unit tests)
- `pytest-cov` (for unit test coverage)
- `mypy` (for static typing)
- `sphinx` (for API documentation)
- `sphinxcontrib-napoleon` (for API documentation)
- `sphinx-rtd-theme` (for API documentation)

## Installation

```bash
# install from pip
pip install csle-cli==<version>
# local install from source
$ pip install -e csle-cli
# or (equivalently):
make install
# force upgrade deps
$ pip install -e csle-cli --upgrade

# git clone and install from source
git clone https://github.com/Limmen/csle
cd csle-cli
pip3 install -e .
```

### Development tools

Install all development tools at once:

```bash
make install_dev
```

Install the Python build tool

```bash
pip install -q build
```

Install `twine` for publishing the package to PyPi:

```bash
python3 -m pip install --upgrade twine
```

Install the `flake8` linter:

```bash
python -m pip install flake8
```

Install `pytest` and `mock`:

```bash
pip install -U pytest mock pytest-mock
```

## API documentation

The latest documentation is available at [https://limmen.dev/csle/docs](https://limmen.dev/csle/docs)

## Static code analysis

To run the Python linter, execute the following command:

```
flake8 .
# or (equivalently):
make lint
```

To run the mypy type checker, execute the following command:

```
mypy .
# or (equivalently):
make types
``` 

## Integration tests

To run the integration tests, execute the following command:

```
pytest
# or (equivalently):
make unit_tests
```

To generate a coverage report, execute the following command:

```
pytest --cov=csle_cli
```

## Run tests and code analysis in different python environments

To run tests and code analysis in different python environemnts, execute the following command:

```bash
tox
# or (equivalently):
make tests
```

## Create a new release and publish to PyPi

First build the package by executing:

```bash
python3 -m build
# or (equivalently)
make build
```

After running the command above, the built package is available at `./dist`.

Push the built package to PyPi by running:

```bash
python3 -m twine upload dist/*
# or (equivalently)
make push
```

To run all commands for the release at once, execute:

```bash
make release
```

## Author & Maintainer

Kim Hammar <kimham@kth.se>

## Copyright and license

Creative Commons

[LICENSE](../../LICENSE.md)

(C) 2020-2023, Kim Hammar

