# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_benchmarks.ipynb (unless otherwise specified).

__all__ = ['generate_db', 'insert_row', 'insert_rows', 'utc_now', 'readable_df']

# Cell
#hide
import pandas as pd
import numpy as np
import arrow
import os
from time import gmtime, strftime
#from prodb.core import generate_db, insert_row, utc_now, readable_df

# Cell

def generate_db(dbpath='db.csv',
                cols=['_c1', '_c2', '_c3'],
                verbose=True,
                prefill=False):
    """Create example database"""
    if prefill:
        df = pd.DataFrame({'name': ['Sam', 'Grant'],
                           'mood': ['😊', '😵'],
                           'message': ['hi', 'hello'],
                           'time_utc' : [arrow.utcnow().format('YYYY-MM-DD HH:mm:ss'),
                                         arrow.utcnow().format('YYYY-MM-DD HH:mm:ss')]})
    else:
        df = pd.DataFrame(columns=cols)
    df.to_csv(dbpath, index=None)
    if verbose: print(f'✓💾 {dbpath} ({os.path.getsize(dbpath)} kb)')
    return df


# Cell

def insert_row(df, data, dbpath='db.csv'):
    new_row = pd.Series(data)
    df = df.append(new_row, ignore_index=True)
    df.to_csv(dbpath, index=None)
    return df

def insert_rows(df, data, dbpath='db.csv'):
    new_rows = pd.DataFrame.from_dict(data)
    df = df.append(new_rows, ignore_index=True)
    df.to_csv(dbpath, index=None)
    return df


# Cell
def utc_now():
    return arrow.utcnow().format('YYYY-MM-DD HH:mm:ss')

# Cell
def readable_df(df, max_rows=8, col_name='human_time'):
    if 'time_utc' in df.columns:
        df[col_name] = df.time_utc.apply(lambda x: arrow.get(x).humanize())
    return df.tail(8)