from enum import Enum
from functools import lru_cache
from typing import cast

from ..extensions import Enums


class CanvasInteractionWebhookType(Enums.KnownString):
    V0_BETACANVASUSERINTERACTED = "v0-beta.canvas.userInteracted"

    def __str__(self) -> str:
        return str(self.value)

    @staticmethod
    @lru_cache(maxsize=None)
    def of_unknown(val: str) -> "CanvasInteractionWebhookType":
        if not isinstance(val, str):
            raise ValueError(f"Value of CanvasInteractionWebhookType must be a string (encountered: {val})")
        newcls = Enum("CanvasInteractionWebhookType", {"_UNKNOWN": val}, type=Enums.UnknownString)  # type: ignore
        return cast(CanvasInteractionWebhookType, getattr(newcls, "_UNKNOWN"))
