from typing import Any, cast, Dict, List, Optional, Type, TypeVar, Union

import attr

from ..extensions import NotPresentError
from ..types import UNSET, Unset

T = TypeVar("T", bound="OligosArchivalChange")


@attr.s(auto_attribs=True, repr=False)
class OligosArchivalChange:
    """IDs of all items that were archived or unarchived, grouped by resource type. This includes the IDs of Oligos along with any IDs of batches that were archived / unarchived."""

    _batch_ids: Union[Unset, List[str]] = UNSET
    _oligo_ids: Union[Unset, List[str]] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def __repr__(self):
        fields = []
        fields.append("batch_ids={}".format(repr(self._batch_ids)))
        fields.append("oligo_ids={}".format(repr(self._oligo_ids)))
        fields.append("additional_properties={}".format(repr(self.additional_properties)))
        return "OligosArchivalChange({})".format(", ".join(fields))

    def to_dict(self) -> Dict[str, Any]:
        batch_ids: Union[Unset, List[Any]] = UNSET
        if not isinstance(self._batch_ids, Unset):
            batch_ids = self._batch_ids

        oligo_ids: Union[Unset, List[Any]] = UNSET
        if not isinstance(self._oligo_ids, Unset):
            oligo_ids = self._oligo_ids

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        # Allow the model to serialize even if it was created outside of the constructor, circumventing validation
        if batch_ids is not UNSET:
            field_dict["batchIds"] = batch_ids
        if oligo_ids is not UNSET:
            field_dict["oligoIds"] = oligo_ids

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any], strict: bool = False) -> T:
        d = src_dict.copy()

        def get_batch_ids() -> Union[Unset, List[str]]:
            batch_ids = cast(List[str], d.pop("batchIds"))

            return batch_ids

        try:
            batch_ids = get_batch_ids()
        except KeyError:
            if strict:
                raise
            batch_ids = cast(Union[Unset, List[str]], UNSET)

        def get_oligo_ids() -> Union[Unset, List[str]]:
            oligo_ids = cast(List[str], d.pop("oligoIds"))

            return oligo_ids

        try:
            oligo_ids = get_oligo_ids()
        except KeyError:
            if strict:
                raise
            oligo_ids = cast(Union[Unset, List[str]], UNSET)

        oligos_archival_change = cls(
            batch_ids=batch_ids,
            oligo_ids=oligo_ids,
        )

        oligos_archival_change.additional_properties = d
        return oligos_archival_change

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties

    def get(self, key, default=None) -> Optional[Any]:
        return self.additional_properties.get(key, default)

    @property
    def batch_ids(self) -> List[str]:
        if isinstance(self._batch_ids, Unset):
            raise NotPresentError(self, "batch_ids")
        return self._batch_ids

    @batch_ids.setter
    def batch_ids(self, value: List[str]) -> None:
        self._batch_ids = value

    @batch_ids.deleter
    def batch_ids(self) -> None:
        self._batch_ids = UNSET

    @property
    def oligo_ids(self) -> List[str]:
        if isinstance(self._oligo_ids, Unset):
            raise NotPresentError(self, "oligo_ids")
        return self._oligo_ids

    @oligo_ids.setter
    def oligo_ids(self, value: List[str]) -> None:
        self._oligo_ids = value

    @oligo_ids.deleter
    def oligo_ids(self) -> None:
        self._oligo_ids = UNSET
