from enum import Enum
from functools import lru_cache
from typing import cast

from ..extensions import Enums


class TranslationGeneticCode(Enums.KnownString):
    STANDARD = "STANDARD"
    VERTEBRATE_MITOCHONDRIAL = "VERTEBRATE_MITOCHONDRIAL"
    YEAST_MITOCHONDRIAL = "YEAST_MITOCHONDRIAL"
    MOLD_PROTOZOAN_COELENTERATE_MITOCHONDRIAL_MYCOPLASMA_SPIROPLASMA = (
        "MOLD_PROTOZOAN_COELENTERATE_MITOCHONDRIAL_MYCOPLASMA_SPIROPLASMA"
    )
    INVERTEBRATE_MITOCHONDRIAL = "INVERTEBRATE_MITOCHONDRIAL"
    CILIATE_DASYCLADACEAN_HEXAMITA_NUCLEAR = "CILIATE_DASYCLADACEAN_HEXAMITA_NUCLEAR"
    ECHINODERM_FLATWORM_MITOCHONDRIAL = "ECHINODERM_FLATWORM_MITOCHONDRIAL"
    EUPLOTID_NUCLEAR = "EUPLOTID_NUCLEAR"
    BACTERIAL_ARCHAEAL_PLANT_PLASTID = "BACTERIAL_ARCHAEAL_PLANT_PLASTID"
    ALTERNATIVE_YEAST_NUCLEAR = "ALTERNATIVE_YEAST_NUCLEAR"
    ASCIDIAN_MITOCHONDRIAL = "ASCIDIAN_MITOCHONDRIAL"
    ALTERNATIVE_FLATWORM_MITOCHONDRIAL = "ALTERNATIVE_FLATWORM_MITOCHONDRIAL"
    CHLOROPHYCEAN_MITOCHONDRIAL = "CHLOROPHYCEAN_MITOCHONDRIAL"
    TREMATODE_MITOCHONDRIAL = "TREMATODE_MITOCHONDRIAL"
    SCENEDESMUS_OBLIQUUS_MITOCHONDRIAL = "SCENEDESMUS_OBLIQUUS_MITOCHONDRIAL"
    THRAUSTOCHYTRIUM_MITOCHONDRIAL = "THRAUSTOCHYTRIUM_MITOCHONDRIAL"
    RHABDOPLEURIDAE_MITOCHONDRIAL = "RHABDOPLEURIDAE_MITOCHONDRIAL"
    CANDIDATE_DIVISION_S_R1_GRACILIBACTERIA = "CANDIDATE_DIVISION_SR1_GRACILIBACTERIA"
    PACHYSOLEN_TANNOPHILUS_NUCLEAR = "PACHYSOLEN_TANNOPHILUS_NUCLEAR"
    MESODINIUM_NUCLEAR = "MESODINIUM_NUCLEAR"
    PERITRICH_NUCLEAR = "PERITRICH_NUCLEAR"
    CEPHALODISCIDAE_MITOCHONDRIAL_UAA_TYR = "CEPHALODISCIDAE_MITOCHONDRIAL_UAA_TYR"

    def __str__(self) -> str:
        return str(self.value)

    @staticmethod
    @lru_cache(maxsize=None)
    def of_unknown(val: str) -> "TranslationGeneticCode":
        if not isinstance(val, str):
            raise ValueError(f"Value of TranslationGeneticCode must be a string (encountered: {val})")
        newcls = Enum("TranslationGeneticCode", {"_UNKNOWN": val}, type=Enums.UnknownString)  # type: ignore
        return cast(TranslationGeneticCode, getattr(newcls, "_UNKNOWN"))
