# -*- coding: utf-8 -*-
#
# cwinpy documentation build configuration file (copied from that for bilby)
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import subprocess
import sys

import cwinpy

sys.path.insert(0, os.path.abspath("../cwinpy/"))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.mathjax",
    "sphinx.ext.intersphinx",
    # "numpydoc",
    "sphinxcontrib.napoleon",
    "sphinx.ext.autosummary",
    "sphinx.ext.autosectionlabel",
    "sphinx_tabs.tabs",
    "recommonmark",
    "sphinx.ext.todo",
    "sphinxcontrib.images",
]

autosummary_generate = True
autodoc_docstring_signature = True
autodoc_default_options = {"members-order": "groupwise", "show-inheritance": True}
todo_include_todos = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = {
    ".rst": "restructuredtext",
    ".txt": "restructuredtext",
    ".md": "markdown",
}

# The master toctree document.
master_doc = "index"

# General information about the project.
project = u"cwinpy"
copyright = u"2019, Matthew Pitkin"
author = u"Matthew Pitkin"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
fullversion = cwinpy.__version__

# The short X.Y version.
version = ".".join(fullversion.split(".")[:2])

# The full version, including alpha/beta/rc tags.
release = fullversion

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = [
    "_build",
    "Thumbs.db",
    ".DS_Store",
    "requirements.txt",
    "comparisons/scripts/outputs/*_data.txt",
    "comparisons/scripts/outputs/*_prior.txt",
    "comparisons/scripts/outputs/*_SNR",
    "comparisons/scripts/outputs/*_Znoise",
    "comparisons/scripts/outputs/*.par",
    "comparisons/scripts/outputs/*.hdf",
    "comparisons/scripts/outputs/*.json",
    "comparisons/scripts/outputs/*.json.old",
    "comparisons/scripts/data",
    "pe/pe_help.txt",
    "pe/cwinpy_pe_dag.ini",
    "pe/data/*.txt",
    "pe/data/*.par",
    "pe/data/*.ini",
    "pe/data/*.txt.gz",
    "pe/data/example1/*.json",
    "pe/data/example1/*.pickle",
    "pe/data/example1/*_trace.png",
    "pe/data/example2/*.json",
    "pe/data/example2/*.pickle",
    "pe/data/example2/*_trace.png",
    "heterodyne/heterodyne_help.txt",
    "heterodyne/heterodyne_dag_help.txt",
    "heterodyne/examples/segments.txt",
]

add_function_parentheses = True
add_module_names = False
show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "cwinpydoc"

# add logo
html_logo = "_static/logo.svg"
html_favicon = "_static/logo_cw.svg"

html_theme_options = {
    # "style_nav_header_background": "#e3e2e1",
    # "logo_only": True,
    "icon_links": [
        {
            "name": "GitHub",
            "url": "https://github.com/cwinpy/cwinpy",
            "icon": "fab fa-github-square",
        },
        {
            "name": "GitLab",
            "url": "https://git.ligo.org/CW/software/cwinpy",
            "icon": "fab fa-gitlab",
        },
    ]
}

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "cwinpy.tex", u"cwinpy Documentation", u"Matthew Pitkin", "manual"),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "cwinpy", u"cwinpy Documentation", [author], 1)]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "cwinpy",
        u"cwinpy Documentation",
        author,
        "cwinpy",
        "One line description of project.",
        "Miscellaneous",
    ),
]

numpydoc_show_class_members = False

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
    "numpy": ("https://numpy.org/doc/stable/", None),
    "scipy": ("https://docs.scipy.org/doc/scipy/reference/", None),
    "matplotlib": ("https://matplotlib.org/", None),
    "astropy": ("https://docs.astropy.org/en/stable/", None),
    "bilby": ("https://lscsoft.docs.ligo.org/bilby/", None),
    "pycondor": ("https://jrbourbeau.github.io/pycondor/", None),
    "numba": ("http://numba.pydata.org/numba-doc/latest/", None),
    "gwpy": ("https://gwpy.github.io/docs/stable/", None),
    "psrqpy": ("https://psrqpy.readthedocs.io/en/stable/", None),
}


# generate cwinpy_pe help string for docs
pe_help = subprocess.getoutput("cwinpy_pe --help")
with open("pe/pe_help.txt", "w") as fp:
    fp.write(pe_help)

# generate cwinpy_heterodyne help string for docs
heterodyne_help = subprocess.getoutput("cwinpy_heterodyne --help")
with open("heterodyne/heterodyne_help.txt", "w") as fp:
    fp.write(heterodyne_help)

# generate cwinpy_heterodyne_dag help string for docs
heterodyne_dag_help = subprocess.getoutput("cwinpy_heterodyne_dag --help")
with open("heterodyne/heterodyne_dag_help.txt", "w") as fp:
    fp.write(heterodyne_dag_help)
