/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto.cmd;

import com.google.common.collect.BiMap;
import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.VectorEntry;
import net.librec.util.FileUtil;
import net.that_recsys_lab.auto.AutoRecommenderJob;
import net.that_recsys_lab.auto.IJobCmd;

public class SplitCmd
implements IJobCmd {
    private AutoRecommenderJob job;
    private Double splitRatio;

    public SplitCmd(AutoRecommenderJob job) {
        this.job = job;
    }

    @Override
    public void execute() throws LibrecException {
        try {
            this.splitRatio = Double.parseDouble(this.getConf().get("data.splitter.trainset.ratio"));
            this.SplitData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void SplitData() throws LibrecException, IOException, ClassNotFoundException {
        this.job.getLOG().info("SplitCMD: START - Splitting training and testing.");
        if (this.job.getCVCount() > 1) {
            for (int i = 1; i <= this.job.getCVCount(); ++i) {
                this.getConf().set("data.splitter.cv.index", String.valueOf(i));
                this.SaveGivenSplitData(i);
                this.job.getLOG().info("SplitCmd: COMPLETE");
            }
        } else {
            this.getConf().set("data.splitter.cv.index", String.valueOf(1));
            this.SaveGivenSplitData(1);
        }
    }

    private void SaveGivenSplitData(int CurrentFold) throws LibrecException, IOException, ClassNotFoundException {
        this.job.getLOG().info("SplitCMD: Splitting training and testing with " + this.splitRatio.toString() + "% ratio on fold " + CurrentFold + ".");
        this.job.getData().buildDataModel();
        SparseMatrix test = this.genTestMatrix();
        SparseMatrix train = this.genTrainMatrix();
        int numUsersTest = test.numRows();
        int numUsersTrain = train.numRows();
        BiMap<String, Integer> userMapping = this.job.getData().getUserMappingData();
        BiMap<String, Integer> itemMapping = this.job.getData().getItemMappingData();
        BiMap<Integer, String> userMappingInverse = userMapping.inverse();
        BiMap<Integer, String> itemMappingInverse = itemMapping.inverse();
        StringBuilder train_out = new StringBuilder();
        for (int i_uid = 0; i_uid < numUsersTrain; ++i_uid) {
            SparseVector row_i = train.row(i_uid);
            String userId = (String)userMappingInverse.get(i_uid);
            for (VectorEntry i : row_i) {
                String itemId = (String)itemMappingInverse.get(i.index());
                double rating = i.get();
                train_out.append(userId).append("\t").append(itemId).append("\t").append(rating).append("\n");
            }
        }
        String saveDataTrain = train_out.toString();
        try {
            String outputPathTrain = this.trainFileNameGen();
            FileUtil.writeString(outputPathTrain, saveDataTrain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder test_out = new StringBuilder();
        for (int i_uid = 0; i_uid < numUsersTest; ++i_uid) {
            SparseVector row_i = test.row(i_uid);
            String userId = (String)userMappingInverse.get(i_uid);
            for (VectorEntry i : row_i) {
                String itemId = (String)itemMappingInverse.get(i.index());
                double rating = i.get();
                test_out.append(userId).append("\t").append(itemId).append("\t").append(rating).append("\n");
            }
        }
        String saveDataTest = test_out.toString();
        try {
            String outputPathTest = this.testFileNameGen();
            FileUtil.writeString(outputPathTest, saveDataTest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Configuration getConf() {
        return this.job.getConf();
    }

    private SparseMatrix genTrainMatrix() {
        return this.genMatrixAux(true);
    }

    private SparseMatrix genTestMatrix() {
        return this.genMatrixAux(false);
    }

    private SparseMatrix genMatrixAux(boolean i) {
        SparseMatrix ret = i ? this.job.getData().getDataSplitter().getTrainData() : this.job.getData().getDataSplitter().getTestData();
        return ret;
    }

    private String trainFileNameGen() {
        return this.fileNameGenAux(true);
    }

    private String testFileNameGen() {
        return this.fileNameGenAux(false);
    }

    private String fileNameGenAux(Boolean flag) {
        String outputPath = this.getConf().get("dfs.data.dir") + '/' + this.getConf().get("dfs.split.dir");
        outputPath = flag != false ? outputPath + "/cv_" + this.getConf().get("data.splitter.cv.index", "1") + "/train.txt" : outputPath + "/cv_" + this.getConf().get("data.splitter.cv.index", "1") + "/test.txt";
        return outputPath;
    }
}

