/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto.cmd;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.util.ReflectionUtil;
import net.that_recsys_lab.auto.AutoRecommenderJob;
import net.that_recsys_lab.auto.IJobCmd;

public class ExpCmd
implements IJobCmd {
    private AutoRecommenderJob job;
    private int m_splitId;

    public ExpCmd(AutoRecommenderJob job) {
        this.job = job;
        this.m_splitId = 1;
    }

    public ExpCmd(AutoRecommenderJob job, int splitId) {
        this.job = job;
        this.m_splitId = splitId;
    }

    @Override
    public void execute() throws IOException, ClassNotFoundException, LibrecException {
        this.job.getLOG().info("ExpCMD: START - Executing recommender job on " + String.valueOf(this.m_splitId + 1) + ".");
        this.getConf().set("data.model.splitter", "testset");
        Integer dataDir = this.getConf().get("dfs.data.dir").length() + 1;
        this.getConf().set("data.splitter.cv.index", String.valueOf(this.m_splitId));
        this.getConf().set("data.input.path", this.trainFileNameGen().substring(dataDir));
        this.getConf().set("data.testset.path", this.testFileNameGen().substring(dataDir));
        try {
            this.job.getData().buildDataModel();
        }
        catch (LibrecException e) {
            e.printStackTrace();
        }
        this.executeRecommenderJob();
        this.job.getLOG().info("ExpCMD: COMPLETE");
    }

    private void executeRecommenderJob() throws ClassNotFoundException, LibrecException, IOException {
        RecommenderContext context = new RecommenderContext(this.getConf(), this.job.getData());
        this.job.generateSimilarityAutoOverload(context);
        Recommender recommender = ReflectionUtil.newInstance(this.job.getRecommenderClass(), this.getConf());
        recommender.recommend(context);
        this.job.m_recommenders.add(this.m_splitId - 1, recommender);
    }

    private Configuration getConf() {
        return this.job.getConf();
    }

    private String trainFileNameGen() throws IOException, ClassNotFoundException {
        return this.fileNameGenAux(true);
    }

    private String testFileNameGen() throws IOException, ClassNotFoundException {
        return this.fileNameGenAux(false);
    }

    private String fileNameGenAux(Boolean flag) throws IOException, ClassNotFoundException {
        String outputPath = this.getConf().get("dfs.data.dir") + '/' + this.getConf().get("dfs.split.dir");
        outputPath = flag != false ? outputPath + "/cv_" + this.m_splitId + "/train.txt" : outputPath + "/cv_" + this.m_splitId + "/test.txt";
        return outputPath;
    }
}

