/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto.cmd;

import java.io.IOException;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.filter.RecommendedFilter;
import net.librec.recommender.Recommender;
import net.librec.recommender.item.RecommendedItem;
import net.librec.util.FileUtil;
import net.librec.util.ReflectionUtil;
import net.that_recsys_lab.auto.AutoRecommenderJob;
import net.that_recsys_lab.auto.IJobCmd;

public class EvalCmd
implements IJobCmd {
    private AutoRecommenderJob job;
    private int m_splitId;

    public EvalCmd(AutoRecommenderJob job) {
        this.job = job;
        this.m_splitId = 1;
    }

    public EvalCmd(AutoRecommenderJob job, int splitId) {
        this.job = job;
        this.m_splitId = splitId;
    }

    @Override
    public void execute() throws LibrecException, IOException, ClassNotFoundException {
        this.job.getLOG().info("EvalCMD: START");
        Recommender recommender = this.job.m_recommenders.get(this.m_splitId - 1);
        this.job.executeEvaluatorAutoOverload(recommender);
        List<RecommendedItem> recommendedList = recommender.getRecommendedList();
        recommendedList = this.filterResult(recommendedList);
        this.saveResult(recommendedList);
        this.job.getLOG().info("EvalCMD: COMPLETE.");
    }

    public void saveResult(List<RecommendedItem> recommendedList) throws LibrecException, IOException, ClassNotFoundException {
        if (recommendedList != null && recommendedList.size() > 0) {
            String outputPath = this.getConf().get("dfs.result.dir");
            outputPath = outputPath + "/out-" + String.valueOf(this.getConf().getInt("data.splitter.cv.index", 1)) + ".txt";
            this.job.getLOG().info("Result path is " + outputPath);
            StringBuilder sb = new StringBuilder();
            for (RecommendedItem recItem : recommendedList) {
                String userId = recItem.getUserId();
                String itemId = recItem.getItemId();
                String value = String.valueOf(recItem.getValue());
                sb.append(userId).append(",").append(itemId).append(",").append(value).append("\n");
            }
            String resultData = sb.toString();
            try {
                FileUtil.writeString(outputPath, resultData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Configuration getConf() {
        return this.job.getConf();
    }

    private List<RecommendedItem> filterResult(List<RecommendedItem> recommendedList) throws ClassNotFoundException, IOException {
        if (this.job.getFilterClass() != null) {
            RecommendedFilter filter = ReflectionUtil.newInstance(this.job.getFilterClass(), null);
            recommendedList = filter.filter(recommendedList);
        }
        return recommendedList;
    }
}

