/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto.cmd;

import java.io.File;
import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.util.DriverClassUtil;
import net.that_recsys_lab.auto.AutoRecommenderJob;
import net.that_recsys_lab.auto.IJobCmd;

public class CheckCmd
implements IJobCmd {
    private AutoRecommenderJob job;

    public CheckCmd(AutoRecommenderJob job) {
        this.job = job;
    }

    private void checkPath(String pathkey) {
        File pathObj = new File(this.job.getConf().get(pathkey));
        if (!pathObj.exists()) {
            this.job.getLOG().info("Error: " + pathkey + " " + pathObj + " does not exist.");
        } else if (!pathObj.isDirectory()) {
            this.job.getLOG().info("Error: " + pathkey + " " + pathObj + " exists but is not a directory.");
        }
    }

    private void checkClasses(String classeskey) {
        String[] asClass = this.job.getConf().getStrings(classeskey);
        for (int i = 0; i < asClass.length; ++i) {
            this.checkClass1(classeskey, asClass[i]);
        }
    }

    private void checkClass(String classkey) {
        String sClass = this.job.getConf().get(classkey);
        this.checkClass1(classkey, sClass);
    }

    private void checkClass1(String classkey, String sClass) {
        if (sClass == null) {
            this.job.getLOG().info("Warning: " + classkey + " is null.");
            return;
        }
        try {
            DriverClassUtil.getClass(sClass);
        }
        catch (ClassNotFoundException e) {
            this.job.getLOG().info("Error: " + classkey + " " + sClass + " does not exist.");
        }
    }

    @Override
    public void execute() throws LibrecException, IOException, ClassNotFoundException {
        this.job.getLOG().info("CheckCmd: START");
        this.job.getLOG().info("CheckCmd: Checking class names");
        this.checkClass("rec.recommender.class");
        this.checkClass("rec.similarity.class");
        this.checkClasses("rec.eval.classes");
        this.job.getLOG().info("CheckCmd: Checking files and paths");
        this.checkPath("dfs.data.dir");
        this.checkPath("dfs.result.dir");
        File dataInputPath = new File(this.job.getConf().get("dfs.data.dir") + "/" + this.job.getConf().get("data.input.path"));
        if (!dataInputPath.exists()) {
            this.job.getLOG().info("Error: Data input path " + dataInputPath + " does not exist.");
        } else if (dataInputPath.isDirectory() && dataInputPath.list().length == 0) {
            this.job.getLOG().info("Error: Data input path " + dataInputPath + " exists but is empty.");
        }
        this.job.getLOG().info("CheckCmd: FINISH");
    }

    private Configuration getConf() {
        return this.job.getConf();
    }
}

