/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import com.google.common.collect.BiMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.librec.common.LibrecException;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.AbstractRecommender;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedItemList;
import net.librec.recommender.item.RecommendedList;
import net.that_recsys_lab.auto.AutoDataAppender;

public class OracleAlgo
extends AbstractRecommender {
    private SparseMatrix resultsMatrix;
    private TextDataConvertor resultsModel;
    private BiMap<Integer, String> userMappingInverse;
    private BiMap<Integer, String> itemMappingInverse;
    private BiMap<String, Integer> result_userMapping;
    private BiMap<String, Integer> result_itemMapping;

    @Override
    protected void trainModel() throws LibrecException {
        System.out.println("** Training model in OracleAlgo **");
        try {
            this.LoadResults();
            this.userMappingInverse = this.userMappingData.inverse();
            this.itemMappingInverse = this.itemMappingData.inverse();
            this.result_userMapping = this.resultsModel.getUserIds();
            this.result_itemMapping = this.resultsModel.getItemIds();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        String user_raw = (String)this.userMappingInverse.get(userIdx);
        String item_raw = (String)this.itemMappingInverse.get(itemIdx);
        double predictedRating = Double.NaN;
        try {
            int user_inner = (Integer)this.result_userMapping.get(user_raw);
            int item_inner = (Integer)this.result_itemMapping.get(item_raw);
            if (this.resultsMatrix.contains(user_inner, item_inner) && (predictedRating = this.resultsMatrix.get(user_inner, item_inner)) == -2.0) {
                predictedRating = 0.0;
            }
        }
        catch (NullPointerException user_inner) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return predictedRating;
    }

    @Override
    protected RecommendedList recommendRank() throws LibrecException {
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        HashSet<Integer> range10 = new HashSet<Integer>();
        for (int i = 1; i <= 10; ++i) {
            range10.add(i);
        }
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            Set<Integer> itemSet = this.trainMatrix.getColumnsSet(userIdx);
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                double predictRating;
                if (itemSet.contains(itemIdx) || Double.isNaN(predictRating = this.predict(userIdx, itemIdx))) continue;
                this.recommendedList.addUserItemIdx(userIdx, itemIdx, predictRating);
            }
            this.recommendedList.topNRankItemsByUser(userIdx, this.topN);
            boolean flag = true;
            List<ItemEntry<Integer, Double>> currItemList = this.recommendedList.getItemIdxListByUserIdx(userIdx);
            for (ItemEntry<Integer, Double> entry : currItemList) {
                int item = Integer.parseInt((String)this.itemMappingInverse.get(entry.getKey()));
                if (range10.contains(item)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            ArrayList<ItemEntry<Integer, Double>> itemList = new ArrayList<ItemEntry<Integer, Double>>(10);
            Integer i = 0;
            while (i < 10) {
                int i_outer = (Integer)this.itemMappingData.get(String.valueOf(i + 1));
                ItemEntry<Integer, Double> item = new ItemEntry<Integer, Double>(i_outer, 0.0);
                itemList.add(i, item);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            ((RecommendedItemList)this.recommendedList).setItemIdxList(userIdx, itemList);
        }
        if (this.recommendedList.size() == 0) {
            throw new IndexOutOfBoundsException("No item is recommended, there is something error in the recommendation algorithm! Please check it!");
        }
        return this.recommendedList;
    }

    private void LoadResults() throws FileNotFoundException {
        Integer cvSplit = Integer.parseInt(this.conf.get("data.splitter.cv.index", "1"));
        String path = this.conf.get("dfs.result.dir") + "/out-" + cvSplit + ".txt";
        AutoDataAppender tempResultModel = new AutoDataAppender(path);
        try {
            tempResultModel.processData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SparseMatrix temp = tempResultModel.getPreferenceMatrix();
        this.resultsMatrix = temp.clone();
        this.resultsModel = tempResultModel;
    }
}

