/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.filter.RecommendedFilter;
import net.librec.job.RecommenderJob;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.similarity.RecommenderSimilarity;
import net.librec.util.ReflectionUtil;
import net.that_recsys_lab.auto.IJobCmd;
import net.that_recsys_lab.auto.cmd.EvalCmd;
import net.that_recsys_lab.auto.cmd.ExpCmd;
import net.that_recsys_lab.auto.cmd.ReRunEvalCmd;
import net.that_recsys_lab.auto.cmd.SeqCmd;
import net.that_recsys_lab.auto.cmd.SplitCmd;
import org.apache.commons.logging.Log;

public class AutoRecommenderJob
extends RecommenderJob {
    private List<IJobCmd> m_commands;
    protected Configuration m_conf;
    protected DataModel m_data;
    protected String m_modelSplit;
    protected int m_cvCount;
    protected Map<String, List<Double>> m_cvEvalResults;
    public List<Recommender> m_recommenders;

    public AutoRecommenderJob(Configuration conf) {
        super(conf);
        this.m_conf = conf;
        this.m_modelSplit = conf.get("data.model.splitter");
        this.m_cvEvalResults = new HashMap<String, List<Double>>();
        this.m_cvCount = this.m_modelSplit.equals("kcv") ? this.m_conf.getInt("data.splitter.cv.number", 1) : 1;
        this.m_recommenders = new ArrayList<Recommender>(this.m_cvCount);
        try {
            this.setData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Configuration getConf() {
        return this.m_conf;
    }

    public Log getLOG() {
        return this.LOG;
    }

    public int getCVCount() {
        return this.m_cvCount;
    }

    public DataModel getData() {
        return this.m_data;
    }

    private void setData() throws ClassNotFoundException, IOException, LibrecException {
        this.m_data = ReflectionUtil.newInstance(this.getDataModelClass(), this.m_conf);
        this.m_conf.set("data.splitter.cv.index", "1");
        this.m_data.buildDataModel();
    }

    public void setCommands(String arg) {
        this.m_commands = new ArrayList<IJobCmd>(5);
        switch (arg) {
            case "split": {
                this.m_commands.add(new SplitCmd(this));
                break;
            }
            case "reRunEval": {
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    this.m_commands.add(new ReRunEvalCmd(this, i));
                }
                break;
            }
            case "exp-eval": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>(2);
                    subcmds.add(new ExpCmd(this, i));
                    subcmds.add(new EvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            case "full": {
                this.m_commands.add(new SplitCmd(this));
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>(2);
                    subcmds.add(new ExpCmd(this, i));
                    subcmds.add(new EvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            default: {
                System.out.println("You've failed to enter a proper command: " + arg + ".  LibRecAuto Terminating.");
                return;
            }
        }
    }

    @Override
    public void runJob() throws LibrecException, IOException, ClassNotFoundException {
        for (IJobCmd cmd : this.m_commands) {
            cmd.execute();
        }
        if (this.m_cvCount > 1) {
            this.printCVAverageResult();
        }
    }

    public void generateSimilarityAutoOverload(RecommenderContext context) {
        String[] similarityKeys = this.m_conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            for (int i = 0; i < similarityKeys.length; ++i) {
                if (this.getSimilarityClass(i) == null) continue;
                RecommenderSimilarity similarity = ReflectionUtil.newInstance(this.getSimilarityClass(i), this.m_conf);
                this.m_conf.set("rec.recommender.similarity.key", similarityKeys[i]);
                similarity.buildSimilarityMatrix(this.m_data);
                if (i == 0) {
                    context.setSimilarity(similarity);
                }
                context.addSimilarities(similarityKeys[i], similarity);
            }
        }
    }

    public void executeEvaluatorAutoOverload(Recommender recommender) throws ClassNotFoundException, IOException, LibrecException {
        block4: {
            block5: {
                if (!this.m_conf.getBoolean("rec.eval.enable")) break block4;
                String[] evalClassKeys = this.m_conf.getStrings("rec.eval.classes");
                if (evalClassKeys == null || evalClassKeys.length <= 0) break block5;
                for (int classIdx = 0; classIdx < evalClassKeys.length; ++classIdx) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(this.getEvaluatorClass(evalClassKeys[classIdx]), null);
                    evaluator.setDataModel(this.m_data);
                    evaluator.setTopN(this.m_conf.getInt("rec.recommender.ranking.topn", 10));
                    double evalValue = recommender.evaluate(evaluator);
                    this.LOG.info("Evaluator info:" + evaluator.getClass().getSimpleName() + " is " + evalValue);
                    this.collectCVResults(evaluator.getClass().getSimpleName(), evalValue);
                }
                break block4;
            }
            Map<Measure.MeasureValue, Double> evalValueMap = recommender.evaluateMap();
            if (evalValueMap == null || evalValueMap.size() <= 0) break block4;
            for (Map.Entry<Measure.MeasureValue, Double> entry : evalValueMap.entrySet()) {
                String evalName = null;
                if (entry == null || entry.getKey() == null) continue;
                if (entry.getKey().getTopN() != null && entry.getKey().getTopN() > 0) {
                    this.LOG.info("Evaluator value:" + (Object)((Object)entry.getKey().getMeasure()) + " top " + entry.getKey().getTopN() + " is " + entry.getValue());
                    evalName = (Object)((Object)entry.getKey().getMeasure()) + " top " + entry.getKey().getTopN();
                } else {
                    this.LOG.info("Evaluator value:" + (Object)((Object)entry.getKey().getMeasure()) + " is " + entry.getValue());
                    evalName = (Object)((Object)entry.getKey().getMeasure()) + "";
                }
                if (null == this.m_cvEvalResults) continue;
                this.collectCVResults(evalName, entry.getValue());
            }
        }
    }

    private void collectCVResults(String evalName, Double evalValue) {
        DataSplitter splitter = this.m_data.getDataSplitter();
        if (splitter != null) {
            if (this.m_cvEvalResults.containsKey(evalName)) {
                this.m_cvEvalResults.get(evalName).add(evalValue);
            } else {
                ArrayList<Double> newList = new ArrayList<Double>();
                newList.add(evalValue);
                this.m_cvEvalResults.put(evalName, newList);
            }
        }
    }

    private List<RecommendedItem> filterResult(List<RecommendedItem> recommendedList) throws ClassNotFoundException, IOException {
        if (this.getFilterClass() != null) {
            RecommendedFilter filter = ReflectionUtil.newInstance(this.getFilterClass(), null);
            recommendedList = filter.filter(recommendedList);
        }
        return recommendedList;
    }

    private void printCVAverageResult() {
        this.LOG.info("Average Evaluation Result of Cross Validation:");
        for (Map.Entry<String, List<Double>> entry : this.m_cvEvalResults.entrySet()) {
            String evalName = entry.getKey();
            List<Double> evalList = entry.getValue();
            double sum = 0.0;
            for (double value : evalList) {
                sum += value;
            }
            double avgEvalResult = sum / (double)evalList.size();
            this.LOG.info("Evaluator value:" + evalName + " is " + avgEvalResult);
        }
    }
}

