/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.math.structure.SparseMatrix;
import net.librec.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDataAppender
extends TextDataConvertor {
    private static final Log LOG = LogFactory.getLog(TextDataConvertor.class);
    private static final int BSIZE = 0x100000;
    private static final String DATA_COLUMN_DEFAULT_FORMAT = "UIR";
    private String dataColumnFormat;
    private String inputDataPath;
    private double binThold = -1.0;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private float loadFilePathRate;
    private float loadDataFileRate;
    private float loadAllFileRate;

    public AutoDataAppender(String path) {
        super(path);
        this.inputDataPath = path;
    }

    @Override
    public void processData() throws IOException {
        this.readDataAuto(DATA_COLUMN_DEFAULT_FORMAT, this.inputDataPath, this.binThold);
    }

    private void readDataAuto(String dataColumnFormat, String inputDataPath, double binThold) throws IOException {
        LOG.info(String.format("Dataset: %s", StringUtil.last(inputDataPath, 38)));
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashBasedTable<Integer, Integer, Long> timeTable = null;
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        if (this.userIds == null) {
            this.userIds = HashBiMap.create();
        }
        if (this.itemIds == null) {
            this.itemIds = HashBiMap.create();
        }
        final ArrayList files = new ArrayList();
        final ArrayList fileSizeList = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileSizeList.add(file.toFile().length());
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        for (String path : inputDataPath.trim().split(" ")) {
            Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super Path>)finder);
        }
        LOG.info("All dataset files " + ((Object)files).toString());
        long allFileSize = 0L;
        for (Long everyFileSize : fileSizeList) {
            allFileSize += everyFileSize.longValue();
        }
        LOG.info("All dataset files size " + Long.toString(allFileSize));
        int readingFileCount = 0;
        long loadAllFileByte = 0L;
        for (File dataFile : files) {
            int len;
            LOG.info("Now loading dataset file " + dataFile.toString().substring(dataFile.toString().lastIndexOf(File.separator) + 1, dataFile.toString().lastIndexOf(".")));
            this.loadFilePathRate = (float)(++readingFileCount) / (float)files.size();
            long readingOneFileByte = 0L;
            FileInputStream fis = new FileInputStream(dataFile);
            FileChannel fileRead = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            String bufferLine = "";
            byte[] bytes = new byte[0x100000];
            while ((len = fileRead.read(buffer)) != -1) {
                this.loadDataFileRate = (float)(readingOneFileByte += (long)len) / (float)fileRead.size();
                this.loadAllFileRate = (float)(loadAllFileByte += (long)len) / (float)allFileSize;
                buffer.flip();
                buffer.get(bytes, 0, len);
                bufferLine = bufferLine.concat(new String(bytes, 0, len));
                bufferLine = bufferLine.replaceAll("\r", "\n");
                String[] bufferData = bufferLine.split("(\n)+");
                boolean isComplete = bufferLine.endsWith("\n");
                int loopLength = isComplete ? bufferData.length : bufferData.length - 1;
                for (int i = 0; i < loopLength; ++i) {
                    String line = bufferData[i];
                    String[] data = line.trim().split("[ \t,]+");
                    String user = data[0];
                    String item = data[1];
                    Double rate = (dataColumnFormat.equals(DATA_COLUMN_DEFAULT_FORMAT) || dataColumnFormat.equals("UIRT")) && data.length >= 3 ? Double.valueOf(data[2]) : 1.0;
                    if (binThold >= 0.0) {
                        rate = rate > binThold ? 1.0 : 0.0;
                    }
                    if (rate == 0.0) {
                        rate = -2.0;
                    }
                    int row = this.userIds.containsKey(user) ? ((Integer)this.userIds.get(user)).intValue() : this.userIds.size();
                    this.userIds.put(user, row);
                    int col = this.itemIds.containsKey(item) ? ((Integer)this.itemIds.get(item)).intValue() : this.itemIds.size();
                    this.itemIds.put(item, col);
                    dataTable.put(row, col, rate);
                    colMap.put(col, row);
                    if (!StringUtils.equals(dataColumnFormat, "UIRT") || data.length < 4) continue;
                    if (timeTable == null) {
                        timeTable = HashBasedTable.create();
                    }
                    long mms = 0L;
                    try {
                        mms = Long.parseLong(data[3]);
                    }
                    catch (NumberFormatException e) {
                        mms = (long)Double.parseDouble(data[3]);
                    }
                    long timestamp = this.timeUnit.toMillis(mms);
                    timeTable.put(row, col, timestamp);
                }
                if (!isComplete) {
                    bufferLine = bufferData[bufferData.length - 1];
                }
                buffer.clear();
            }
            fileRead.close();
            fis.close();
        }
        int numRows = this.numUsers();
        int numCols = this.numItems();
        this.preferenceMatrix = new SparseMatrix(numRows, numCols, dataTable, colMap);
        if (timeTable != null) {
            this.datetimeMatrix = new SparseMatrix(numRows, numCols, timeTable, colMap);
        }
        dataTable = null;
        timeTable = null;
    }

    @Override
    public int numUsers() {
        return this.userIds.size();
    }

    @Override
    public int numItems() {
        return this.itemIds.size();
    }

    @Override
    public int getUserId(String rawId) {
        return (Integer)this.userIds.get(rawId);
    }

    @Override
    public int getItemId(String rawId) {
        return (Integer)this.itemIds.get(rawId);
    }

    @Override
    public BiMap<String, Integer> getUserIds() {
        return this.userIds;
    }

    @Override
    public BiMap<String, Integer> getItemIds() {
        return this.itemIds;
    }
}

