/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.librec.math.algorithm.Maths;

public class StringUtil {
    public static final String EMPTY = "";
    private static String SEP = "\n";
    private static final DecimalFormat intFormatter = new DecimalFormat("#,###");
    public static final String[] emptyStringArray = new String[0];
    private static final int PAD_LIMIT = 8192;

    public static String last(String str, int maxLength) {
        if (str.length() + 3 <= maxLength) {
            return str;
        }
        return "..." + str.substring(str.length() - maxLength + 3);
    }

    public static float toFloat(String str) {
        return Float.parseFloat(str);
    }

    public static float toFloat(String str, float val) {
        return str != null ? Float.parseFloat(str) : val;
    }

    public static int toInt(String str) {
        return Integer.parseInt(str);
    }

    public static int toInt(String str, int val) {
        return str != null ? Integer.parseInt(str) : val;
    }

    public static long toLong(String str) {
        return Long.parseLong(str);
    }

    public static long toLong(String str, long val) {
        return str != null ? Long.parseLong(str) : val;
    }

    public static double toDouble(String str) {
        return Double.parseDouble(str);
    }

    public static double toDouble(String str, double val) {
        return str != null ? Double.parseDouble(str) : val;
    }

    public static void toClipboard(String data) throws Exception {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(data);
        cb.setContents(ss, ss);
    }

    public static boolean isOn(String option) {
        switch (option.toLowerCase()) {
            case "on": 
            case "true": {
                return true;
            }
        }
        return false;
    }

    public static String toString(Object[] objs, String sep) {
        return Joiner.on(sep).skipNulls().join(objs);
    }

    public static String toString(Object[] strings) {
        return StringUtil.toString(strings, ", ");
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtil.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtil.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String toString(double data) {
        return StringUtil.toString(data, 4);
    }

    public static String toString(long data) {
        return intFormatter.format(data);
    }

    public static String toString(double[][] data) {
        int rows = data.length;
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: " + rows + " x " + data[0].length + "\n");
        for (int i = 0; i < rows; ++i) {
            sb.append("[");
            for (int j = 0; j < data[i].length; ++j) {
                sb.append((float)data[i][j]);
                if (j >= data[i].length - 1) continue;
                sb.append("\t");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static String toString(int[][] data) {
        int rows = data.length;
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: " + rows + " x " + data[0].length + "\n");
        for (int i = 0; i < rows; ++i) {
            sb.append("[");
            for (int j = 0; j < data[i].length; ++j) {
                sb.append(data[i][j]);
                if (j >= data[i].length - 1) continue;
                sb.append("\t");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static String toString(Number data, int bits) {
        double val = data.doubleValue();
        if (Maths.isInt(val)) {
            return (int)val + EMPTY;
        }
        String format = "%." + bits + "f";
        return String.format(format, val);
    }

    public static List<String> toList(String str, String reg) {
        Iterable<String> iter = Splitter.on(reg).omitEmptyStrings().trimResults().split(str);
        return Lists.newArrayList(iter);
    }

    public static String shortStr(String input) {
        return StringUtil.shortStr(input, 50);
    }

    public static String shortStr(String input, int len) {
        int begin = 0;
        if (input.length() > len) {
            begin = input.length() - len;
        }
        return input.substring(begin);
    }

    public static <T> String toString(Collection<T> ts) {
        if (ts instanceof Multiset) {
            StringBuilder sb = new StringBuilder();
            Multiset es = (Multiset)ts;
            for (Object e : es.elementSet()) {
                int count = es.count(e);
                sb.append(e + ", " + count + "\n");
            }
            return sb.toString();
        }
        return StringUtil.toString(ts, ",");
    }

    public static <T> String toString(Collection<T> ts, String sep) {
        return Joiner.on(sep).skipNulls().join(ts);
    }

    public static <K, V> String toString(Map<K, V> map) {
        return StringUtil.toString(map, "\n");
    }

    public static <K, V> String toString(Map<K, V> map, String sep) {
        return Joiner.on(sep).withKeyValueSeparator(" -> ").join(map);
    }

    public static String toString(double[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < data.length; ++i) {
            sb.append(StringUtil.toString(data[i]));
            if (i >= data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(int[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            if (i >= data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toSection(List<String> msgs) {
        StringBuilder sb = new StringBuilder();
        int repeat = 50;
        sb.append(" *\n");
        for (String msg : msgs) {
            sb.append(" * " + msg + "\n");
            if (msg.length() <= repeat) continue;
            repeat = msg.length();
        }
        sb.append(" *\n");
        String stars = StringUtil.repeat('*', repeat);
        String head = "\n/*" + stars + "\n";
        sb.insert(0, head);
        String tail = " *" + stars + "/";
        sb.append(tail);
        return sb.toString();
    }

    public static String[] getStrings(String str) {
        Collection<String> values = StringUtil.getStringCollection(str);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        String delim = ",";
        return StringUtil.getStringCollection(str, delim);
    }

    public static Collection<String> getStringCollection(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return EMPTY;
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(",");
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static String arrayToString(int[] ints) {
        if (ints.length == 0) {
            return EMPTY;
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(ints[0]);
        for (int idx = 1; idx < ints.length; ++idx) {
            sbuf.append(",");
            sbuf.append(ints[idx]);
        }
        return sbuf.toString();
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || str.trim().isEmpty()) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }
}

