/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.librec.conf.Configurable;
import net.librec.conf.Configuration;

public class ReflectionUtil {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();

    public static <T> T newInstance(Class<T> theClass, Class<?> paramClass, Object paramValue) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(paramClass);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(paramValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        T result = ReflectionUtil.newInstance(theClass);
        ReflectionUtil.setConf(result, conf);
        return result;
    }

    public static <T> T newInstance(Class<T> theClass) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null && theObject instanceof Configurable) {
            ((Configurable)theObject).setConf(conf);
        }
    }
}

