/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.librec.recommender.Recommender;
import org.apache.commons.lang.StringUtils;

public class DriverClassUtil {
    private static BiMap<String, String> driverClassBiMap = HashBiMap.create();
    private static BiMap<String, String> driverClassInverseBiMap;

    public static Class<?> getClass(String driver) throws ClassNotFoundException {
        if (StringUtils.isBlank(driver)) {
            return null;
        }
        if (StringUtils.contains(driver, ".")) {
            return Class.forName(driver);
        }
        String fullName = (String)driverClassBiMap.get(driver);
        return Class.forName(fullName);
    }

    public static String getDriverName(String clazz) throws ClassNotFoundException {
        if (StringUtils.isBlank(clazz)) {
            return null;
        }
        return (String)driverClassInverseBiMap.get(clazz);
    }

    public static String getDriverName(Class<? extends Recommender> clazz) throws ClassNotFoundException {
        if (clazz == null) {
            return null;
        }
        String driverName = (String)driverClassInverseBiMap.get(clazz.getName());
        if (StringUtils.isNotBlank(driverName)) {
            return driverName;
        }
        return clazz.getSimpleName().toLowerCase().replace("recommender", "");
    }

    static {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = DriverClassUtil.class.getClassLoader().getResourceAsStream("driver.classes.props");
            prop.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            driverClassBiMap.put(key, value);
        }
        driverClassInverseBiMap = driverClassBiMap.inverse();
    }
}

