/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.List;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class MSDSimilarity
extends AbstractRecommenderSimilarity {
    @Override
    protected double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        if (thisList == null || thatList == null || thisList.size() < 1 || thatList.size() < 1 || thisList.size() != thatList.size()) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (int i = 0; i < thisList.size(); ++i) {
            double thisValue = thisList.get(i).doubleValue();
            double thatValue = thatList.get(i).doubleValue();
            sum += Math.pow(thisValue - thatValue, 2.0);
        }
        double sim = (double)thisList.size() / sum;
        if (Double.isInfinite(sim)) {
            sim = 1.0;
        }
        return sim;
    }
}

