/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.librec.math.structure.SparseVector;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class KRCCSimilarity
extends AbstractRecommenderSimilarity {
    @Override
    public double getCorrelation(SparseVector thisVector, SparseVector thatVector) {
        if (thisVector == null || thatVector == null || thisVector.size() != thatVector.size()) {
            return Double.NaN;
        }
        ArrayList<Double> thisList = new ArrayList<Double>();
        ArrayList<Double> thatList = new ArrayList<Double>();
        int[] nArray = thatVector.getIndex();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer idx = nArray[i];
            thisList.add(thisVector.get(idx));
            thatList.add(thatVector.get(idx));
        }
        return this.getSimilarity(thisList, thatList);
    }

    @Override
    protected double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        if (thisList == null || thatList == null || thisList.size() < 2 || thatList.size() < 2) {
            return Double.NaN;
        }
        HashSet<Integer> commonIndices = new HashSet<Integer>();
        for (int i = 0; i < thisList.size(); ++i) {
            if (!(thisList.get(i).doubleValue() > 0.0) || !(thatList.get(i).doubleValue() > 0.0)) continue;
            commonIndices.add(i);
        }
        int numCommonIndices = commonIndices.size();
        if (numCommonIndices < 2) {
            return Double.NaN;
        }
        ArrayList commonIndexList = new ArrayList(commonIndices);
        double sum = 0.0;
        for (int i = 0; i < commonIndexList.size(); ++i) {
            for (int j = i + 1; j < commonIndexList.size(); ++j) {
                double thatDiff;
                double thisDiff = thisList.get((Integer)commonIndexList.get(i)).doubleValue() - thisList.get((Integer)commonIndexList.get(j)).doubleValue();
                if (!(thisDiff * (thatDiff = thatList.get((Integer)commonIndexList.get(i)).doubleValue() - thatList.get((Integer)commonIndexList.get(j)).doubleValue()) < 0.0)) continue;
                sum += 1.0;
            }
        }
        return 1.0 - 4.0 * sum / (double)(numCommonIndices * (numCommonIndices - 1));
    }
}

