/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.List;
import net.librec.data.DataModel;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class CPCSimilarity
extends AbstractRecommenderSimilarity {
    private double median;

    @Override
    public void buildSimilarityMatrix(DataModel dataModel) {
        SparseMatrix trainMatrix = dataModel.getDataSplitter().getTrainData();
        double maximum = 0.0;
        double minimum = 100.0;
        for (MatrixEntry me : trainMatrix) {
            if (me.get() > maximum) {
                maximum = me.get();
            }
            if (!(me.get() < minimum)) continue;
            minimum = me.get();
        }
        this.median = (maximum + minimum) / 2.0;
        super.buildSimilarityMatrix(dataModel);
    }

    @Override
    protected double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        if (thisList == null || thatList == null || thisList.size() < 1 || thatList.size() < 1 || thisList.size() != thatList.size()) {
            return Double.NaN;
        }
        double innerProduct = 0.0;
        double thisPower2 = 0.0;
        double thatPower2 = 0.0;
        for (int i = 0; i < thisList.size(); ++i) {
            double thisDiff = thisList.get(i).doubleValue() - this.median;
            double thatDiff = thatList.get(i).doubleValue() - this.median;
            innerProduct += thisDiff * thatDiff;
            thisPower2 += thisDiff * thisDiff;
            thatPower2 += thatDiff * thatDiff;
        }
        return innerProduct / Math.sqrt(thisPower2 * thatPower2);
    }
}

