/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.ArrayList;
import java.util.List;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.convertor.appender.SocialDataAppender;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.similarity.RecommenderSimilarity;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRecommenderSimilarity
implements RecommenderSimilarity {
    protected Configuration conf;
    protected SymmMatrix similarityMatrix;

    @Override
    public void buildSimilarityMatrix(DataModel dataModel) {
        this.conf = dataModel.getContext().getConf();
        String similarityKey = this.conf.get("rec.recommender.similarity.key", "user");
        if (StringUtils.isNotBlank(similarityKey)) {
            if (StringUtils.equals(similarityKey, "social")) {
                this.buildSocialSimilarityMatrix(dataModel);
            }
            if (StringUtils.contains(similarityKey, "feature")) {
                this.buildFeatureSimilarityMatrix(dataModel);
            } else {
                boolean isUser = StringUtils.equals(similarityKey, "user");
                SparseMatrix trainMatrix = dataModel.getDataSplitter().getTrainData();
                int numUsers = trainMatrix.numRows();
                int numItems = trainMatrix.numColumns();
                int count = isUser ? numUsers : numItems;
                this.similarityMatrix = new SymmMatrix(count);
                for (int i = 0; i < count; ++i) {
                    SparseVector thisVector;
                    SparseVector sparseVector = thisVector = isUser ? trainMatrix.row(i) : trainMatrix.column(i);
                    if (thisVector.getCount() == 0) continue;
                    for (int j = i + 1; j < count; ++j) {
                        double sim;
                        SparseVector thatVector;
                        SparseVector sparseVector2 = thatVector = isUser ? trainMatrix.row(j) : trainMatrix.column(j);
                        if (thatVector.getCount() == 0 || Double.isNaN(sim = this.getCorrelation(thisVector, thatVector)) || sim == 0.0) continue;
                        this.similarityMatrix.set(i, j, sim);
                    }
                }
            }
        }
    }

    public void buildSocialSimilarityMatrix(DataModel dataModel) {
        SparseMatrix trainMatrix = dataModel.getDataSplitter().getTrainData();
        SparseMatrix socialMatrix = ((SocialDataAppender)dataModel.getDataAppender()).getUserAppender();
        int numUsers = trainMatrix.numRows();
        this.similarityMatrix = new SymmMatrix(numUsers);
        for (int userIdx = 0; userIdx < numUsers; ++userIdx) {
            SparseVector userVector = trainMatrix.row(userIdx);
            if (userVector.getCount() == 0) continue;
            List<Integer> socialList = socialMatrix.getRows(userIdx);
            for (int socialIdx : socialList) {
                double sim;
                SparseVector socialVector = trainMatrix.row(socialIdx);
                if (socialVector.getCount() == 0 || Double.isNaN(sim = this.getCorrelation(userVector, socialVector))) continue;
                this.similarityMatrix.set(userIdx, socialIdx, sim);
            }
        }
    }

    public void buildFeatureSimilarityMatrix(DataModel dataModel) {
        int numElements;
        String similarityKey = this.conf.get("rec.recommender.similarity.key", "user");
        boolean isUser = StringUtils.contains(similarityKey, "user");
        SparseMatrix featureMatrix = isUser ? dataModel.getFeatureAppender().getUserFeatures() : dataModel.getFeatureAppender().getItemFeatures();
        int count = numElements = featureMatrix.numRows();
        this.similarityMatrix = new SymmMatrix(count);
        for (int i = 0; i < count; ++i) {
            SparseVector thisVector = featureMatrix.row(i);
            if (thisVector.getCount() == 0) continue;
            for (int j = i + 1; j < count; ++j) {
                double sim;
                SparseVector thatVector = featureMatrix.row(j);
                if (thatVector.getCount() == 0 || Double.isNaN(sim = this.getCorrelation(thisVector, thatVector)) || sim == 0.0) continue;
                this.similarityMatrix.set(i, j, sim);
            }
        }
    }

    public double getCorrelation(SparseVector thisVector, SparseVector thatVector) {
        ArrayList<Double> thisList = new ArrayList<Double>();
        ArrayList<Double> thatList = new ArrayList<Double>();
        int[] nArray = thatVector.getIndex();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer idx = nArray[i];
            if (!thisVector.contains(idx)) continue;
            thisList.add(thisVector.get(idx));
            thatList.add(thatVector.get(idx));
        }
        double sim = this.getSimilarity(thisList, thatList);
        if (!Double.isNaN(sim)) {
            int n2 = thisList.size();
            int shrinkage = this.conf.getInt("rec.similarity.shrinkage", 0);
            if (shrinkage > 0) {
                sim *= (double)n2 / ((double)(n2 + shrinkage) + 0.0);
            }
        }
        return sim;
    }

    protected abstract double getSimilarity(List<? extends Number> var1, List<? extends Number> var2);

    @Override
    public SymmMatrix getSimilarityMatrix() {
        return this.similarityMatrix;
    }
}

