/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.item;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.librec.annotation.LibrecWaring;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;
import net.librec.recommender.item.UserItemRatingEntry;
import net.librec.util.Lists;

public class RecommendedItemList
implements RecommendedList,
Serializable {
    private static final long serialVersionUID = -7323990117815388002L;
    private transient List<List<ItemEntry<Integer, Double>>> elementData;
    private transient int[] indexOfUserIdx;
    private int size;
    private Queue<Integer> idleIndexList;
    private int maxUserIdx;

    public RecommendedItemList(int maxUserIdxParam) {
        this(maxUserIdxParam, 0);
    }

    public RecommendedItemList(int maxUserIdxParam, int initCapacityParam) {
        this.maxUserIdx = maxUserIdxParam;
        if (this.maxUserIdx < 0) {
            throw new IllegalArgumentException("Illegal max user index: " + this.maxUserIdx);
        }
        initCapacityParam = initCapacityParam > this.maxUserIdx ? this.maxUserIdx + 1 : initCapacityParam;
        this.elementData = new ArrayList<List<ItemEntry<Integer, Double>>>(initCapacityParam);
        this.idleIndexList = new LinkedList<Integer>();
        this.indexOfUserIdx = new int[this.maxUserIdx + 1];
        Arrays.fill(this.indexOfUserIdx, -1);
        this.size = 0;
    }

    public boolean setItemIdxList(int userIdx, List<ItemEntry<Integer, Double>> itemList) {
        if (itemList.size() > 0) {
            this.userRangeCheck(userIdx);
            this.checkIndex(userIdx);
            this.elementData.set(this.indexOfUserIdx[userIdx], itemList);
            return true;
        }
        return false;
    }

    public boolean addItemIdxList(int userIdx, ArrayList<ItemEntry<Integer, Double>> itemList) {
        this.userRangeCheck(userIdx);
        this.checkIndex(userIdx);
        this.elementData.get(this.indexOfUserIdx[userIdx]).addAll(itemList);
        return true;
    }

    @Override
    public boolean addUserItemIdx(int userIdx, int itemIdx, double rating) {
        this.userRangeCheck(userIdx);
        this.checkIndex(userIdx);
        this.elementData.get(this.indexOfUserIdx[userIdx]).add(new ItemEntry<Integer, Double>(itemIdx, rating));
        return true;
    }

    @Override
    public List<ItemEntry<Integer, Double>> getItemIdxListByUserIdx(int userIdx) throws IndexOutOfBoundsException {
        this.userRangeCheck(userIdx);
        int index = this.indexOfUserIdx[userIdx];
        if (index < 0) {
            return new ArrayList<ItemEntry<Integer, Double>>();
        }
        return this.elementData.get(index);
    }

    private void checkIndex(int userIdx) {
        int index = this.indexOfUserIdx[userIdx];
        if (index < 0) {
            if (!this.idleIndexList.isEmpty()) {
                this.elementData.set(this.indexOfUserIdx[userIdx], new ArrayList());
                this.indexOfUserIdx[userIdx] = this.idleIndexList.poll();
            } else {
                this.indexOfUserIdx[userIdx] = this.elementData.size();
                this.elementData.add(new ArrayList());
            }
            ++this.size;
        }
    }

    @Override
    @Deprecated
    @LibrecWaring(value="It is best not to use this method! Too slow and the complexity is O(itemIdxList.size()).")
    public double getEntryValue(int userIdx, int itemIdx) throws IndexOutOfBoundsException {
        this.userRangeCheck(userIdx);
        List<ItemEntry<Integer, Double>> itemEntryList = this.getItemIdxListByUserIdx(userIdx);
        for (ItemEntry<Integer, Double> itemEntry : itemEntryList) {
            if (itemEntry == null || itemEntry.getKey() != itemIdx) continue;
            return itemEntry.getValue();
        }
        return -1.0;
    }

    @Override
    public List<ItemEntry<Integer, Double>> removeUserIdx(int userIdx) throws IndexOutOfBoundsException {
        this.userRangeCheck(userIdx);
        int index = this.indexOfUserIdx[userIdx];
        List<ItemEntry<Integer, Double>> oldValue = new ArrayList<ItemEntry<Integer, Double>>();
        if (index > 0) {
            oldValue = this.elementData.get(index);
            this.elementData.set(index, null);
            this.indexOfUserIdx[userIdx] = -1;
            --this.size;
            this.idleIndexList.offer(index);
        }
        return oldValue;
    }

    @Override
    public void topNRank(int itemTopN) {
        Iterator<Integer> userItr = this.userIterator();
        while (userItr.hasNext()) {
            int userIdx = userItr.next();
            this.setItemIdxList(userIdx, Lists.sortItemEntryListTopK(this.getItemIdxListByUserIdx(userIdx), true, itemTopN));
        }
    }

    @Override
    public void topNRankItemsByUser(int userIdx, int topN) {
        this.setItemIdxList(userIdx, Lists.sortItemEntryListTopK(this.getItemIdxListByUserIdx(userIdx), true, topN));
    }

    @Override
    public boolean contains(int userIdx) {
        return userIdx <= this.maxUserIdx && this.indexOfUserIdx[userIdx] >= 0;
    }

    public int getSize() {
        return this.size;
    }

    private void userRangeCheck(int userIdx) {
        if (userIdx > this.maxUserIdx) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(userIdx, " User", this.maxUserIdx));
        }
    }

    private String outOfBoundsMsg(int index, String msg, int size) {
        return msg + " Index: " + index + ", Size: " + size;
    }

    @Override
    public Iterator<Integer> userIterator() {
        return new UserListIterator();
    }

    @Override
    public Iterator<UserItemRatingEntry> entryIterator() {
        return new UserItemRatingItr();
    }

    @Override
    public int size() {
        return this.size;
    }

    private class UserItemRatingItr
    implements Iterator<UserItemRatingEntry> {
        private final UserItemRatingEntry entry = new UserItemRatingEntry();
        private int userIdx;
        private Iterator<Integer> userItr;
        private Iterator<ItemEntry<Integer, Double>> itemEntryItr;

        public UserItemRatingItr() {
            this.userItr = RecommendedItemList.this.userIterator();
            if (this.userItr.hasNext()) {
                this.userIdx = this.userItr.next();
                this.itemEntryItr = RecommendedItemList.this.getItemIdxListByUserIdx(this.userIdx).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.itemEntryItr.hasNext() || this.userItr.hasNext();
        }

        @Override
        public UserItemRatingEntry next() {
            if (!this.itemEntryItr.hasNext()) {
                this.userIdx = this.userItr.next();
                this.itemEntryItr = RecommendedItemList.this.getItemIdxListByUserIdx(this.userIdx).iterator();
            }
            ItemEntry<Integer, Double> itemEntry = this.itemEntryItr.next();
            this.entry.setUserIdx(this.userIdx);
            this.entry.setItemIdx(itemEntry.getKey());
            this.entry.setValue(itemEntry.getValue());
            return this.entry;
        }

        @Override
        @Deprecated
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class UserListIterator
    implements Iterator<Integer> {
        int cursor = 0;
        int lastRet = -1;

        public UserListIterator() {
            while (this.cursor + 1 <= RecommendedItemList.this.maxUserIdx && RecommendedItemList.this.indexOfUserIdx[this.cursor] < 0) {
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= RecommendedItemList.this.maxUserIdx && RecommendedItemList.this.indexOfUserIdx[this.cursor] >= 0;
        }

        @Override
        public Integer next() {
            this.lastRet = this.cursor++;
            while (this.cursor + 1 <= RecommendedItemList.this.maxUserIdx && RecommendedItemList.this.indexOfUserIdx[this.cursor] < 0) {
                ++this.cursor;
            }
            return this.lastRet;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                RecommendedItemList.this.removeUserIdx(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

