/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.hybrid;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.librec.common.LibrecException;
import net.librec.math.structure.SparseVector;
import net.librec.recommender.AbstractRecommender;

public class HybridRecommender
extends AbstractRecommender {
    Table<Integer, Integer, Double> userItemRanks = HashBasedTable.create();
    protected float lambda;
    Map<Integer, Integer> itemDegrees = new HashMap<Integer, Integer>();

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.lambda = this.conf.getFloat("rec.hybrid.lambda").floatValue();
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            this.itemDegrees.put(itemIdx, this.trainMatrix.columnSize(itemIdx));
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        if (!this.userItemRanks.containsRow(userIdx)) {
            double sum;
            this.userItemRanks.clear();
            SparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
            Set<Integer> itemsSet = itemRatingsVector.getIndexSet();
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            for (int tempUserIdx = 0; tempUserIdx < this.numUsers; ++tempUserIdx) {
                SparseVector tempItemRatingsVector = this.trainMatrix.row(tempUserIdx);
                sum = 0.0;
                int tempItemsCount = tempItemRatingsVector.getCount();
                int[] nArray = tempItemRatingsVector.getIndex();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int tempItemIdx = nArray[i];
                    if (!itemsSet.contains(tempItemIdx)) continue;
                    sum += 1.0 / Math.pow(this.itemDegrees.get(tempItemIdx).intValue(), this.lambda);
                }
                if (tempItemsCount <= 0) continue;
                userResources.put(tempUserIdx, sum / (double)tempItemsCount);
            }
            for (int tempItemIdx = 0; tempItemIdx < this.numItems; ++tempItemIdx) {
                if (itemsSet.contains(tempItemIdx)) continue;
                SparseVector tempUserRatingsVector = this.trainMatrix.column(tempItemIdx);
                sum = 0.0;
                for (int tempUserIdx : tempUserRatingsVector.getIndex()) {
                    sum += userResources.containsKey(tempUserIdx) ? (Double)userResources.get(tempUserIdx) : 0.0;
                }
                double score = sum / Math.pow(this.itemDegrees.get(tempItemIdx).intValue(), 1.0f - this.lambda);
                this.userItemRanks.put(userIdx, tempItemIdx, score);
            }
        }
        return this.userItemRanks.contains(userIdx, itemIdx) ? this.userItemRanks.get(userIdx, itemIdx) : 0.0;
    }
}

