/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.recommender.AbstractRecommender;

@ModelData(value={"isRating", "slopeone", "devMatrix", "cardMatrix", "trainMatrix"})
public class SlopeOneRecommender
extends AbstractRecommender {
    private DenseMatrix devMatrix;
    private DenseMatrix cardMatrix;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.devMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.cardMatrix = new DenseMatrix(this.numItems, this.numItems);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] items;
            SparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
            for (int itemIdx : items = itemRatingsVector.getIndex()) {
                double userItemRating = itemRatingsVector.get(itemIdx);
                for (int comparedItemIdx : items) {
                    if (itemIdx == comparedItemIdx) continue;
                    double comparedRating = itemRatingsVector.get(comparedItemIdx);
                    this.devMatrix.add(itemIdx, comparedItemIdx, userItemRating - comparedRating);
                    this.cardMatrix.add(itemIdx, comparedItemIdx, 1.0);
                }
            }
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            for (int comparedItemIdx = 0; comparedItemIdx < this.numItems; ++comparedItemIdx) {
                double card = this.cardMatrix.get(itemIdx, comparedItemIdx);
                if (!(card > 0.0)) continue;
                double sum = this.devMatrix.get(itemIdx, comparedItemIdx);
                this.devMatrix.set(itemIdx, comparedItemIdx, sum / card);
            }
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        SparseVector itemRatingsVector = this.trainMatrix.row(userIdx, itemIdx);
        double predictRatings = 0.0;
        double cardinaryValues = 0.0;
        for (int comparedItemIdx : itemRatingsVector.getIndex()) {
            double cardinaryValue = this.cardMatrix.get(itemIdx, comparedItemIdx);
            if (!(cardinaryValue > 0.0)) continue;
            predictRatings += (this.devMatrix.get(itemIdx, comparedItemIdx) + itemRatingsVector.get(comparedItemIdx)) * cardinaryValue;
            cardinaryValues += cardinaryValue;
        }
        return cardinaryValues > 0.0 ? predictRatings / cardinaryValues : this.globalMean;
    }
}

