/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import java.util.Iterator;
import net.librec.common.LibrecException;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;

public class PersonalityDiagnosisRecommender
extends AbstractRecommender {
    private float sigma;
    private double prior;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.prior = 1.0 / (double)this.numUsers;
        this.sigma = this.conf.getFloat("rec.PersonalityDiagnosis.sigma").floatValue();
    }

    @Override
    protected void trainModel() throws LibrecException {
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        double[] scaleProbs = new double[ratingScale.size()];
        SparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
        SparseVector userRatingsVector = this.trainMatrix.column(itemIdx);
        int index = 0;
        Iterator iterator = ratingScale.iterator();
        while (iterator.hasNext()) {
            double ratingValue = (Double)iterator.next();
            double prob = 0.0;
            for (VectorEntry vectorEntry : userRatingsVector) {
                int ratedUserIdx = vectorEntry.index();
                double userRatingValue = vectorEntry.get();
                SparseVector ratedItemRatingsVector = this.trainMatrix.row(ratedUserIdx);
                double prod = 1.0;
                for (VectorEntry itemRatingEntry : itemRatingsVector) {
                    int ratedItemIdx = itemRatingEntry.index();
                    double itemRatingValue = itemRatingEntry.get();
                    double ratedItemRatingValue = ratedItemRatingsVector.get(ratedItemIdx);
                    if (!(ratedItemRatingValue > 0.0)) continue;
                    prod *= this.gaussian(itemRatingValue, ratedItemRatingValue, this.sigma);
                }
                prob += this.gaussian(ratingValue, userRatingValue, this.sigma) * prod;
            }
            scaleProbs[index++] = prob *= this.prior;
        }
        int maxIdx = 0;
        double max = -2.147483648E9;
        for (int ratingIdx = 0; ratingIdx < scaleProbs.length; ++ratingIdx) {
            if (!(scaleProbs[ratingIdx] > max)) continue;
            max = scaleProbs[ratingIdx];
            maxIdx = ratingIdx;
        }
        return (Double)ratingScale.get(maxIdx);
    }

    protected double gaussian(double x, double mu, double sigma) {
        return Math.exp(-0.5 * Math.pow(x - mu, 2.0) / (sigma * sigma));
    }
}

