/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.recommender.AbstractRecommender;

public class BipolarSlopeOneRecommender
extends AbstractRecommender {
    private DenseMatrix likeDevMatrix;
    private DenseMatrix dislikeDevMatrix;
    private DenseMatrix likeCardMatrix;
    private DenseMatrix dislikeCardMatrix;
    private int[] averageRating;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.likeDevMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.likeCardMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.dislikeDevMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.dislikeCardMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.averageRating = new int[this.numUsers];
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] items;
            SparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
            this.averageRating[userIdx] = (int)itemRatingsVector.mean();
            for (int itemIdx : items = itemRatingsVector.getIndex()) {
                double userItemRating = itemRatingsVector.get(itemIdx);
                for (int comparedItemIdx : items) {
                    if (itemIdx == comparedItemIdx) continue;
                    double comparedRating = itemRatingsVector.get(comparedItemIdx);
                    if (userItemRating >= (double)this.averageRating[userIdx] && comparedRating >= (double)this.averageRating[userIdx]) {
                        this.likeDevMatrix.add(itemIdx, comparedItemIdx, userItemRating - comparedRating);
                        this.likeCardMatrix.add(itemIdx, comparedItemIdx, 1.0);
                        continue;
                    }
                    if (!(userItemRating < (double)this.averageRating[userIdx]) || !(comparedRating < (double)this.averageRating[userIdx])) continue;
                    this.dislikeDevMatrix.add(itemIdx, comparedItemIdx, userItemRating - comparedRating);
                    this.dislikeCardMatrix.add(itemIdx, comparedItemIdx, 1.0);
                }
            }
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            for (int comparedItemIdx = 0; comparedItemIdx < this.numItems; ++comparedItemIdx) {
                double sum;
                double card = this.likeCardMatrix.get(itemIdx, comparedItemIdx);
                if (card > 0.0) {
                    sum = this.likeDevMatrix.get(itemIdx, comparedItemIdx);
                    this.likeDevMatrix.set(itemIdx, comparedItemIdx, sum / card);
                }
                if (!((card = this.dislikeCardMatrix.get(itemIdx, comparedItemIdx)) > 0.0)) continue;
                sum = this.dislikeDevMatrix.get(itemIdx, comparedItemIdx);
                this.dislikeCardMatrix.set(itemIdx, comparedItemIdx, sum / card);
            }
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        SparseVector itemRatingsVector = this.trainMatrix.row(userIdx, itemIdx);
        double predictRatings = 0.0;
        double cardinaryValues = 0.0;
        for (int comparedItemIdx : itemRatingsVector.getIndex()) {
            double cardinaryValue = this.likeCardMatrix.get(itemIdx, comparedItemIdx);
            if (cardinaryValue > 0.0) {
                predictRatings += (this.likeDevMatrix.get(itemIdx, comparedItemIdx) + itemRatingsVector.get(comparedItemIdx)) * cardinaryValue;
                cardinaryValues += cardinaryValue;
            }
            if (!((cardinaryValue = this.dislikeCardMatrix.get(itemIdx, comparedItemIdx)) > 0.0)) continue;
            predictRatings += (this.dislikeDevMatrix.get(itemIdx, comparedItemIdx) + itemRatingsVector.get(comparedItemIdx)) * cardinaryValue;
            cardinaryValues += cardinaryValue;
        }
        return cardinaryValues > 0.0 ? predictRatings / cardinaryValues : this.globalMean;
    }
}

