/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import com.google.common.collect.HashBasedTable;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;

public class AssociationRuleRecommender
extends AbstractRecommender {
    private SparseMatrix associations;
    private DenseMatrix userItemRates;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.userItemRates = new DenseMatrix(this.trainMatrix.numRows, this.trainMatrix.numColumns);
        for (MatrixEntry entry : this.trainMatrix) {
            this.userItemRates.set(entry.row(), entry.column(), entry.get());
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        HashBasedTable<Integer, Integer, Double> associationTable = HashBasedTable.create(this.numItems, this.numItems);
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            SparseVector userRatingsVector = this.trainMatrix.column(itemIdx);
            int userCount = userRatingsVector.size();
            for (int assoItemIdx = 0; assoItemIdx < this.numItems; ++assoItemIdx) {
                int count = 0;
                for (VectorEntry vectorEntry : userRatingsVector) {
                    int userIdx = vectorEntry.index();
                    double assoRatings = this.trainMatrix.get(userIdx, assoItemIdx);
                    if (!(assoRatings > 0.0)) continue;
                    ++count;
                }
                if (count <= 0) continue;
                double conf = ((double)count + 0.0) / (double)userCount;
                associationTable.put(itemIdx, assoItemIdx, conf);
            }
        }
        this.associations = new SparseMatrix(this.numItems, this.numItems, associationTable);
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        double predictRatings = 0.0;
        for (VectorEntry mapEntry : this.associations.column(itemIdx)) {
            int assoItemIdx = mapEntry.index();
            double support = mapEntry.get();
            double value = this.userItemRates.get(userIdx, assoItemIdx);
            predictRatings += value * support;
        }
        return predictRatings;
    }
}

