/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.context.rating;

import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.recommender.SocialRecommender;

@ModelData(value={"isRating", "trustsvd", "userFactors", "itemFactors", "impItemFactors", "userBiases", "itemBiases", "socialMatrix", "trainMatrix"})
public class TrustSVDRecommender
extends SocialRecommender {
    private DenseMatrix impItemFactors;
    private DenseMatrix trusteeFactors;
    private DenseVector trusteeWeights;
    private DenseVector trusterWeights;
    private DenseVector impItemWeights;
    private DenseVector userBiases;
    private DenseVector itemBiases;
    protected double regBias;
    protected LoadingCache<Integer, List<Integer>> userItemsCache;
    protected LoadingCache<Integer, List<Integer>> userTrusteeCache;
    protected static String cacheSpec;

    @Override
    public void setup() throws LibrecException {
        super.setup();
        this.regBias = this.conf.getDouble("rec.bias.regularization", 0.01);
        cacheSpec = this.conf.get("guava.cache.spec", "maximumSize=200,expireAfterAccess=2m");
        this.userBiases = new DenseVector(this.numUsers);
        this.itemBiases = new DenseVector(this.numItems);
        this.userBiases.init(this.initMean, this.initStd);
        this.itemBiases.init(this.initMean, this.initStd);
        this.trusteeFactors = new DenseMatrix(this.numUsers, this.numFactors);
        this.impItemFactors = new DenseMatrix(this.numItems, this.numFactors);
        this.trusteeFactors.init(this.initMean, this.initStd);
        this.impItemFactors.init(this.initMean, this.initStd);
        this.trusteeWeights = new DenseVector(this.numUsers);
        this.trusterWeights = new DenseVector(this.numUsers);
        this.impItemWeights = new DenseVector(this.numItems);
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int userFriendCount = this.socialMatrix.columnSize(userIdx);
            this.trusteeWeights.set(userIdx, userFriendCount > 0 ? 1.0 / Math.sqrt(userFriendCount) : 1.0);
            userFriendCount = this.socialMatrix.rowSize(userIdx);
            this.trusterWeights.set(userIdx, userFriendCount > 0 ? 1.0 / Math.sqrt(userFriendCount) : 1.0);
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            int itemUsersCount = this.trainMatrix.columnSize(itemIdx);
            this.impItemWeights.set(itemIdx, itemUsersCount > 0 ? 1.0 / Math.sqrt(itemUsersCount) : 1.0);
        }
        this.userItemsCache = this.trainMatrix.rowColumnsCache(cacheSpec);
        this.userTrusteeCache = this.socialMatrix.rowColumnsCache(cacheSpec);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            int userIdx;
            this.loss = 0.0;
            DenseMatrix tempUserFactors = new DenseMatrix(this.numUsers, this.numFactors);
            DenseMatrix trusteeTempFactors = new DenseMatrix(this.numUsers, this.numFactors);
            for (MatrixEntry matrixEntry : this.trainMatrix) {
                int factorIdx;
                userIdx = matrixEntry.row();
                int itemIdx = matrixEntry.column();
                double realRating = matrixEntry.get();
                double userBiasValue = this.userBiases.get(userIdx);
                double itemBiasValue = this.itemBiases.get(itemIdx);
                double predictRating = this.globalMean + userBiasValue + itemBiasValue + DenseMatrix.rowMult(this.userFactors, userIdx, this.itemFactors, itemIdx);
                List<Integer> impItemsList = null;
                try {
                    impItemsList = this.userItemsCache.get(userIdx);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                if (impItemsList.size() > 0) {
                    double sum = 0.0;
                    for (int impItemIdx : impItemsList) {
                        sum += DenseMatrix.rowMult(this.impItemFactors, impItemIdx, this.itemFactors, itemIdx);
                    }
                    predictRating += sum / Math.sqrt(impItemsList.size());
                }
                List<Integer> trusteesList = null;
                try {
                    trusteesList = this.userTrusteeCache.get(userIdx);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                if (trusteesList.size() > 0) {
                    double sum = 0.0;
                    for (int trusteeIdx : trusteesList) {
                        sum += DenseMatrix.rowMult(this.trusteeFactors, trusteeIdx, this.itemFactors, itemIdx);
                    }
                    predictRating += sum / Math.sqrt(trusteesList.size());
                }
                double error = predictRating - realRating;
                this.loss += error * error;
                double userWeightDenom = Math.sqrt(impItemsList.size());
                double trusteeWeightDenom = Math.sqrt(trusteesList.size());
                double userWeight = 1.0 / userWeightDenom;
                double itemWeight = this.impItemWeights.get(itemIdx);
                double sgd = error + this.regBias * userWeight * userBiasValue;
                this.userBiases.add(userIdx, (double)(-this.learnRate) * sgd);
                sgd = error + this.regBias * itemWeight * itemBiasValue;
                this.itemBiases.add(itemIdx, (double)(-this.learnRate) * sgd);
                this.loss += this.regBias * userWeight * userBiasValue * userBiasValue + this.regBias * itemWeight * itemBiasValue * itemBiasValue;
                double[] sumImpItemsFactors = new double[this.numFactors];
                for (int factorIdx2 = 0; factorIdx2 < this.numFactors; ++factorIdx2) {
                    double sum = 0.0;
                    for (int impItemIdx : impItemsList) {
                        sum += this.impItemFactors.get(impItemIdx, factorIdx2);
                    }
                    sumImpItemsFactors[factorIdx2] = userWeightDenom > 0.0 ? sum / userWeightDenom : sum;
                }
                double[] sumTrusteesFactors = new double[this.numFactors];
                for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    double sum = 0.0;
                    for (int trusteeIdx : trusteesList) {
                        sum += this.trusteeFactors.get(trusteeIdx, factorIdx);
                    }
                    sumTrusteesFactors[factorIdx] = trusteeWeightDenom > 0.0 ? sum / trusteeWeightDenom : sum;
                }
                for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    double userFactorValue = this.userFactors.get(userIdx, factorIdx);
                    double itemFactorValue = this.itemFactors.get(itemIdx, factorIdx);
                    double deltaUser = error * itemFactorValue + (double)this.regUser * userWeight * userFactorValue;
                    double deltaItem = error * (userFactorValue + sumImpItemsFactors[factorIdx] + sumTrusteesFactors[factorIdx]) + (double)this.regItem * itemWeight * itemFactorValue;
                    tempUserFactors.add(userIdx, factorIdx, deltaUser);
                    this.itemFactors.add(itemIdx, factorIdx, (double)(-this.learnRate) * deltaItem);
                    this.loss += (double)this.regUser * userWeight * userFactorValue * userFactorValue + (double)this.regItem * itemWeight * itemFactorValue * itemFactorValue;
                    for (int impItemIdx : impItemsList) {
                        double impItemFactorValue = this.impItemFactors.get(impItemIdx, factorIdx);
                        double impItemWeightValue = this.impItemWeights.get(impItemIdx);
                        double deltaImpItem = error * itemFactorValue / userWeightDenom + (double)this.regItem * impItemWeightValue * impItemFactorValue;
                        this.impItemFactors.add(impItemIdx, factorIdx, (double)(-this.learnRate) * deltaImpItem);
                        this.loss += (double)this.regItem * impItemWeightValue * impItemFactorValue * impItemFactorValue;
                    }
                    for (int trusteeIdx : trusteesList) {
                        double trusteeFactorValue = this.trusteeFactors.get(trusteeIdx, factorIdx);
                        double trusteeWeightValue = this.trusteeWeights.get(trusteeIdx);
                        double deltaTrustee = error * itemFactorValue / trusteeWeightDenom + (double)this.regUser * trusteeWeightValue * trusteeFactorValue;
                        trusteeTempFactors.add(trusteeIdx, factorIdx, deltaTrustee);
                        this.loss += (double)this.regUser * trusteeWeightValue * trusteeFactorValue * trusteeFactorValue;
                    }
                }
            }
            for (MatrixEntry socialMatrixEntry : this.socialMatrix) {
                userIdx = socialMatrixEntry.row();
                int trusteeIdx = socialMatrixEntry.column();
                double socialValue = socialMatrixEntry.get();
                if (socialValue == 0.0) continue;
                double predtictSocialValue = DenseMatrix.rowMult(this.userFactors, userIdx, this.trusteeFactors, trusteeIdx);
                double socialError = predtictSocialValue - socialValue;
                this.loss += (double)this.regSocial * socialError * socialError;
                double deriValue = (double)this.regSocial * socialError;
                double trusterWeightValue = this.trusterWeights.get(userIdx);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    double userFactorValue = this.userFactors.get(userIdx, factorIdx);
                    double trusteeFactorValue = this.trusteeFactors.get(trusteeIdx, factorIdx);
                    tempUserFactors.add(userIdx, factorIdx, deriValue * trusteeFactorValue + (double)this.regSocial * trusterWeightValue * userFactorValue);
                    trusteeTempFactors.add(trusteeIdx, factorIdx, deriValue * userFactorValue);
                    this.loss += (double)this.regSocial * trusterWeightValue * userFactorValue * userFactorValue;
                }
            }
            this.userFactors.addEqual(tempUserFactors.scale(-this.learnRate));
            this.trusteeFactors.addEqual(trusteeTempFactors.scale(-this.learnRate));
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        double predictRating = this.globalMean + this.userBiases.get(userIdx) + this.itemBiases.get(itemIdx) + DenseMatrix.rowMult(this.userFactors, userIdx, this.itemFactors, itemIdx);
        List<Integer> userItemsList = null;
        try {
            userItemsList = this.userItemsCache.get(userIdx);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (userItemsList.size() > 0) {
            double sum = 0.0;
            for (int userItemIdx : userItemsList) {
                sum += DenseMatrix.rowMult(this.impItemFactors, userItemIdx, this.itemFactors, itemIdx);
            }
            predictRating += sum / Math.sqrt(userItemsList.size());
        }
        List<Integer> trusteeList = null;
        try {
            trusteeList = this.userTrusteeCache.get(userIdx);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (trusteeList.size() > 0) {
            double sum = 0.0;
            for (int trusteeIdx : trusteeList) {
                sum += DenseMatrix.rowMult(this.trusteeFactors, trusteeIdx, this.itemFactors, itemIdx);
            }
            predictRating += sum / Math.sqrt(trusteeList.size());
        }
        return predictRating;
    }

    @Override
    protected double predict(int userIdx, int itemIdx, boolean bounded) throws LibrecException {
        double predictRating = this.predict(userIdx, itemIdx);
        return predictRating;
    }
}

